# Example for: model.restraints.pick(), model.restraints.condense()

# This will pick only restraints that include at least one
# CA atom and write them to a file.

log.verbose()
env = environ()
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

code = '1fas'
mdl = model(env, file=code)
aln = alignment(env)
aln.append_model(mdl, atom_files=code, align_codes=code)
aln.append_model(mdl, atom_files=code+'.ini', align_codes=code+'-ini')
mdl.generate_topology(aln, sequence=code+'-ini')
mdl.transfer_xyz(aln)
mdl.build(initialize_xyz=False, build_method='INTERNAL_COORDINATES')

mdl.restraints.make(aln, restraint_type='stereo', spline_on_site=False)
mdl.energy()

mdl.pick_atoms(aln, atom_types='CA N C O')
mdl.restraints.pick(add_restraints=False, restraint_sel_atoms=1)
# Delete the unselected restraints from memory:
mdl.restraints.condense()
mdl.energy()

mdl.restraints.write(file='1fas.rsr')
