# Example for: model.write_data()

# This will calculate solvent accessibility, dihedral angles, and 
# residue-residue neighbors for a structure in the PDB file.

log.verbose()

# Get topology library for radii and the model without waters and HETATMs:
env = environ()
env.io.hetatm = False
env.io.water = False

env.libs.topology.read(file='$(LIB)/top_heav.lib')
mdl = model(env, file='1fas')

# Calculate residue solvent accessibilities, dihedral angles, and 
# residue-residue neighbors:
myedat = energy_data()
myedat.radii_factor = 1.0 # The default is 0.82 (for soft-sphere restraints)
mdl.write_data(file='1fas', edat=myedat, output='PSA DIH NGH SSM CRV')
