# Loop refinement of an existing model

from modeller.automodel import *

log.verbose()
env = environ()

# directories for input atom files
env.io.atom_files_directory = './:../atom_files'

# Create a new class based on 'loopmodel' so that we can redefine
# select_loop_atoms (necessary)
class myloop(loopmodel):
    # This routine picks the residues to be refined by loop modeling
    def select_loop_atoms(self):
        # 4 residue insertion (1st loop)
        self.pick_atoms(selection_segment=('19:', '28:'),
                        selection_status='INITIALIZE')

m = myloop(env,
           inimodel='1fdx.B99990001.pdb', # initial model of the target
           sequence='1fdx')               # code of the target

m.loop.starting_model= 20           # index of the first loop model 
m.loop.ending_model  = 23           # index of the last loop model
m.loop.md_level = refine.very_fast  # loop refinement method

m.make()
