# Example for: profile.scan()

env = environ()

# Read in the target profile
prf = profile(env, file='T3lzt-uniprot90.prf', profile_format='TEXT')

# Scan against all profiles in the 'profiles.list' file
prf.scan(profile_list_file = 'profiles.list',
         matrix_offset     = -200,
         rr_file           = '${LIB}/blosum62.sim.mat',
         gap_penalties_1d  = (-1900, -95),
         score_statistics  = False,
         output_alignments = True,
         output_scores     = False,
         output_score_file = 'T3lzt-ppscan.scores',
         profile_format    = 'TEXT',
         max_aln_evalue    = 1,
         aln_base_filename = 'T3lzt-ppscan',
         pssm_weights_type = 'HH1',
         write_summary     = True,
         summary_file      = 'T3lzt-ppscan.sum')
