from modeller import *
from modeller.scripts import complete_pdb

# Load the C extension module; this needs to be compiled with commands like
# the following (these work for most Linux systems, where 'modXXX' is your
# Modeller binary):
#
# swig -python -noproxy cuser_feat.i
# gcc -shared -Wall -fPIC `modXXX --cflags` -I/usr/include/python2.4 \
#     cuser_feat.c cuser_feat_wrap.c -o _cuser_feat.so -lm
import _cuser_feat

env = environ()

env.io.atom_files_directory = '../atom_files'
log.verbose()
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

class mydist(features.feature):
    """An implementation of Modeller's distance feature (type 1) as a
       C extension module"""

    numatoms = 2
    _builtin_index = _cuser_feat.myfeat_create()


mdl = complete_pdb(env, "1fdx")
sel = selection(mdl)
rsr = mdl.restraints
at = mdl.atoms
rsr.add(forms.gaussian(group=physical.bond,
                       feature=mydist(at['CA:1'], at['C:1']),
                       mean=1.5380, stdev=0.0364))
sel.energy()
