"""MODELLER, a package for protein structure modeling

   See http://salilab.org/modeller/ for further details
"""

# Version check
import sys
if sys.version_info[0] < 2 or sys.version_info[1] < 3:
    raise ImportError, "This module requires Python 2.3 or later"

try:
    import config
except ImportError:
    config = None

# Special processing on Windows to find _modeller.pyd and Modeller DLLs:
if hasattr(config, 'install_dir') and hasattr(sys, 'dllhandle'):
    dpath = config.install_dir + '\\modlib\\python%d.%d' % sys.version_info[0:2]
    if dpath not in sys.path:
        sys.path.insert(0, dpath)
    try:
        import os
        dpath = config.install_dir + '\\bin;'
        if dpath not in os.environ['PATH']:
            os.environ['PATH'] = dpath + os.environ['PATH']
    except ImportError:
        pass
    del dpath

# Set Modeller install location and license
import _modeller
if hasattr(config, 'license'):
    _modeller.set_license_key(config.license)
if hasattr(config, 'install_dir'):
    _modeller.set_install_dir(config.install_dir)

_modeller.start_modeller()

from energy_data import energy_data
from io_data import io_data
from environ import environ
from group_restraints import group_restraints
from error import ModellerError
from model import model
from alignment import alignment
from sequence_db import sequence_db
from profile import profile
from saxsdata import saxsdata
from density import density
from pssmdb import pssmdb
from excluded_pair import excluded_pair
from rigid_body import rigid_body
from symmetry import symmetry
from selection import selection
from util.logger import log
from information import info
import pseudo_atom
import virtual_atom
import modfile
import features
import forms
import secondary_structure
import terms
import physical
del error, parameters

# Load in readline, if available, to make interactive use easier
try:
    if len(sys.argv) > 0 and sys.argv[0] == '-' and sys.stdin.isatty():
        import readline
except (ImportError, AttributeError):
    pass

# Write out header (copyright info, etc.)
_modeller.write_header()

del sys, _modeller, config
