import _modeller
import util.top as top
from modeller.util.modobject import modobject
from modeller.util import array

class density(modobject):
    """Holds all information from an EM (electron microscopy) density file"""
    __modpt = None
    env = None
    top = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_density(obj)
        return obj

    def __init__(self, env, **vars):
        self.env = env.copy()
        self.top = top.top(self.env)
        if len(vars) > 0:
            self.read(**vars)

    def __del__(self):
        _modeller.free_density(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def read(self, px=0, py=0, pz=0, cc_func_type='ccf', **vars):
        """Read in a density file"""
        return self.top.read_density('density.read', den=self.modpt, px=px,
                                     py=py, pz=pz, cc_func_type=cc_func_type, 
                                     **vars)

    def grid_search(self, **vars):
        """Dock a structure into the EM density map"""
        return self.top.em_grid_search('density.grid_search', den=self.modpt,
                                       **vars)

    def __get_resolution(self):
        return _modeller.density_resolution_get(self.modpt)
    def __set_resolution(self, val):
        _modeller.density_resolution_set(self.modpt, val)
    def __get_grid_sqr_sum(self):
        return _modeller.density_grid_sqr_sum_get(self.modpt)
    def __get_grid(self):
        return array.array_3dfloat(_modeller.density_grid_get(self.modpt))
    def __get_norm_factor(self):
        return _modeller.density_norm_factor_get(self.modpt)

    modpt = property(__get_modpt)
    resolution = property(__get_resolution, __set_resolution, doc="Resolution")
    grid_sqr_sum = property(__get_grid_sqr_sum,
                            doc="Sum of squares over all grid points")
    grid = property(__get_grid, doc="3D grid of density values (z,y,x)")
    norm_factor = property(__get_norm_factor, doc="Normalization factor")
