import _modeller
from modeller.util.modobject import modobject

class io_data(modobject):
    """Controls reading from/writing to atom files"""

    hetatm = False
    hydrogen = False
    water = False
    atom_files_directory = ''
    __modpt = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_io_data()
        return obj

    def __init__(self, copy=None, **kwargs):
        if copy:
            for member in copy.__dict__:
                if 'io_data' not in member:
                    self.__dict__[member] = copy.__dict__[member]
        for key in kwargs:
            if key in dir(io_data):
                exec("self."+key+"="+str(kwargs[key]))
            else:
                raise KeyError, str(key)

    def __del__(self):
        _modeller.free_io_data(self.__modpt)

    def __get_modpt(self):
        modpt = self.__modpt
        _modeller.set_io_data(modpt, self.hydrogen, self.hetatm, self.water,
                              self.atom_files_directory)
        return modpt

    modpt = property(__get_modpt)
