import os
import slave
import sys

class local_slave(slave.slave):
    """A slave running on the same machine"""

    def __init__(self):
        # No support for Windows systems just yet:
        if hasattr(sys, 'dllhandle'):
            raise NotImplementedError, "local_slave not implemented for Windows"
        slave.slave.__init__(self)

    def start(self, path, id, output):
        slave.slave.start(self, path, id, output)
        cmd = "%s -slave %s >& '%s' &" % (path, id, output)
        print cmd
        os.system(cmd)

    def __repr__(self):
        return "<Slave on localhost>"
