import _modeller
import util.top as top

class parameters(object):
    """All information from a parameter file"""

    def __init__(self, libs):
        self.env = libs.env
        self.__modpt = _modeller.libraries_prm_get(libs.modpt)
        self.top = top.top(self.env)

    def clear(self):
        """Clear all parameter information"""
        _modeller.clear_parameters(self.modpt)

    def append(self, file):
        """Append information from a CHARMM parameter file"""
        return self.top.new_read_parameters('parameters.append', file=file,
                                            prm=self.modpt,
                                            libs=self.env.libs.modpt)

    def read(self, file):
        """Read information from a CHARMM parameter file"""
        self.clear()
        return self.append(file)

    def __get_modpt(self):
        return self.__modpt
    def __get_in_memory(self):
        return _modeller.parameters_read(self.modpt)

    modpt = property(__get_modpt)
    in_memory = property(__get_in_memory)
