import _modeller
import util.top as top
from modeller.util.modobject import modobject

class pssmdb(modobject):
    """Holds a database of PSSMs"""
    __modpt = None
    env = None
    top = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_pssmdbobj(obj)
        return obj

    def __init__(self, env, **vars):
        self.env = env.copy()
        self.top = top.top(self.env)
        if len(vars) > 0:
            self.read(**vars)

    def __del__(self):
        _modeller.free_pssmdbobj(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def read(self, **vars):
        return self.top.read_pssmdb('pssmdb.read', psm=self.modpt,
                                    **vars)
    modpt = property(__get_modpt)
