import _modeller
from modeller.top_interpreter import util

class variables:
    deftops = { 'include_file':'__mod', 'variables':[''], 'arguments':[''],
                'string_arguments':[''], 'operation':'', 'result':'',
                'routine':'', 'numb_of_sequences':None,
                'numb_of_sequences2':None, 'n_schedule':None, 'schedule_step':0,
                'topology_model':3, 'rand_seed':-8123, 'seq_id':-999.0,
                'output_control':[1, 0, 1, 1, 0], 'sel1':[1], 'sel1out':[1],
                'sel2':[1], 'sel3':[1], 'sel':[1], 'selout':[1] }
    ourvars = {}
    aln_nseq = [ 0, 0 ]
    edat_members = { 'lennard_jones_switch':[0], 'coulomb_switch':[0],
                     'contact_shell':0.0, 'relative_dielectric':0.0,
                     'radii_factor':0.0, 'update_dynamic':0.0,
                     'nonbonded_sel_atoms':0, 'covalent_cys':False,
                     'excl_local':[False], 'nlogn_use':0, 'sphere_stdv':0.0,
                     'dynamic_pairs':False, 'dynamic_sphere':False,
                     'dynamic_coulomb':False, 'dynamic_lennard':False,
                     'dynamic_modeller':False, 'dynamic_access':False,
                     'dynamic_gbsa':False }
    io_members = { 'hydrogen_io':False, 'hetatm_io':False, 'water_io':False,
                   'atom_files_directory':'' }

    def __init__(self, topcmds):
        self.topcmds = topcmds
        self.topvars = {}
        for var in self.deftops.keys():
            self.ourvars[var] = self.deftops[var]
        for var in self.edat_members.keys():
            self.ourvars[var] = self.edat_members[var]
        for var in self.io_members.keys():
            self.ourvars[var] = self.io_members[var]

    def __setitem__(self, key, value):
        if key in self.topini and key not in self.deftops \
                 and key not in self.edat_members \
                 and key not in self.io_members:
            (typ, num) = self.topini[key]
            if typ == 'L':
                value = self.parse_bool(value)
            if num != 1 and type(value) is not list \
               and type(value) is not tuple:
                value = [ value ]
            util.set_topvars({key:value}, self.topvars, self.topini)
            if key == 'align_codes':
                self.to_alignment(1, value, _modeller.alignment_codes_set)
            elif key == 'align_codes2':
                self.to_alignment(2, value, _modeller.alignment_codes_set)
            elif key == 'atom_files':
                self.to_alignment(1, value, _modeller.alignment_atom_files_set)
            elif key == 'atom_files2':
                self.to_alignment(2, value, _modeller.alignment_atom_files_set)
        else:
            if key in self.ourvars and self.ourvars[key] == None:
                raise SyntaxError, key.upper() + " is a read-only variable"
            if key in self.ourvars and (type(self.ourvars[key]) is bool or
               (type(self.ourvars[key]) is list and
                type(self.ourvars[key][0]) is bool)):
                value = self.parse_bool(value)
            if key in self.edat_members:
                edat = self.topcmds.get_edat()
                exec("edat." + key + " = value")
            elif key in self.io_members:
                io = self.topcmds.get_io()
                if key[-3:] == '_io':
                    key = key[:-3]
                exec("io." + key + " = value")
            elif key == 'schedule_step':
                self.set_sched_step(value)
            elif key == 'topology_model':
                self.set_topmod(value)
            elif key == 'rand_seed':
                self.set_rand_seed(value)
            elif key == 'seq_id':
                self.set_seq_id(value)
            elif key == 'output_control':
                self.set_output_control(value)
            elif key == 'sel1out':
                self['sel1'] = value
            elif key == 'selout':
                num = self['pick_atoms_set']
                num = min(3, max(1, num))
                names = { 1:'sel1', 2:'sel2', 3:'sel3' }
                self[names[num]] = value
            else:
                if type(value) is str:
                    value = util.str_macro(value, self.topvars)
                self.ourvars[key] = value

    def __getitem__(self, key):
        if key in self.ourvars:
            if key in self.edat_members:
                edat = self.topcmds.get_edat()
                return eval("edat." + key)
            elif key in self.io_members:
                io = self.topcmds.get_io()
                if key[-3:] == '_io':
                    key = key[:-3]
                return eval("io." + key)
            elif key == 'numb_of_sequences':
                return self.get_aln_nseq(1)
            elif key == 'numb_of_sequences2':
                return self.get_aln_nseq(2)
            elif key == 'n_schedule':
                return self.get_n_schedule()
            elif key == 'schedule_step':
                return self.get_sched_step()
            elif key == 'topology_model':
                return self.get_topmod()
            elif key == 'rand_seed':
                return self.get_rand_seed()
            elif key == 'seq_id':
                return self.get_seq_id()
            elif key == 'output_control':
                return self.get_output_control()
            elif key == 'sel':
                num = self['pick_atoms_set']
                num = min(3, max(1, num))
                names = { 1:'sel1', 2:'sel2', 3:'sel3' }
                return self[names[num]]
            else:
                return self.ourvars[key]
        elif key in self.topini:
            value = util.get_topvars(key, self.topvars)
            return value
        else:
            raise IndexError

    def __contains__(self, item):
        return (item in self.ourvars or item in self.topini)

    def get_aln_nseq(self, num):
        aln = self.topcmds.get_aln(num)
        return _modeller.alignment_nseq_get(aln)
 
    def get_sched(self):
        mdl = self.topcmds.get_mdl(1)
        return _modeller.model_sched_get(mdl)

    def get_topmod(self):
        tpl = self.topcmds.get_tpl()
        return _modeller.topology_submodel_get(tpl)

    def set_topmod(self, val):
        tpl = self.topcmds.get_tpl()
        _modeller.topology_submodel_set(tpl, val)

    def get_rand_seed(self):
        libs = self.topcmds.get_libs()
        return _modeller.get_libraries_rand_seed(libs)

    def set_rand_seed(self, val):
        libs = self.topcmds.get_libs()
        _modeller.set_libraries_rand_seed(libs, val)

    def get_seq_id(self):
        mdl = self.topcmds.get_mdl(1)
        return _modeller.get_model_seq_id(mdl)

    def set_seq_id(self, val):
        mdl = self.topcmds.get_mdl(1)
        _modeller.set_model_seq_id(mdl, val)

    def get_output_control(self):
        vals = []
        for indx in range(6):
            vals.append(_modeller.modget_log(indx))
        return vals

    def set_output_control(self, vals):
        for (indx, val) in enumerate(vals):
            _modeller.modset_log(indx, val)

    def get_n_schedule(self):
        return _modeller.schedule_nsch_get(self.get_sched())

    def get_sched_step(self):
        return _modeller.schedule_step_get(self.get_sched())

    def set_sched_step(self, val):
        return _modeller.schedule_step_set(self.get_sched(), val)

    def to_alignment(self, num, value, setfunc):
        aln = self.topcmds.get_aln(num)
        len_aln = _modeller.alignment_nseq_get(aln)
        self.aln_nseq[num - 1] = len_aln
        numal = min(len(value), len_aln)
        for num in range(numal):
            setfunc(aln, num, value[num])

    def parse_bool(self, varval):
        notlist = False
        if type(varval) is not list:
            varval = [ varval ]
            notlist = True
        newvarval = []
        for var in varval:
            if type(var) is str:
                var = var.lower()
                if var == 'on':
                    newvarval.append(True)
                elif var == 'off':
                    newvarval.append(False)
                else:
                    newvarval.append(var)
            else:
                newvarval.append(var)
        if notlist:
            return newvarval[0]
        else:
            return newvarval
