import _modeller
import sys
from modeller.error import ModellerError

class logger(object):
    """Allow messages to be printed to the Modeller logfile"""

    def __init__(self):
        # Use our own write function for all log output
        _modeller.modset_log_function(self.write)

    def level(self, output=1, notes=0, warnings=0, errors=1, memory=0):
        """Set the logging level - i.e. which messages to output"""
        for (indx, val) in enumerate((output, notes, warnings, errors, memory)):
            _modeller.modset_log(indx, val)

    def minimal(self):
        """Only print important logging messages"""
        self.level(output=1, notes=0, warnings=0, errors=1, memory=0)

    def verbose(self):
        """Print verbose logging messages"""
        self.level(output=1, notes=1, warnings=1, errors=1, memory=1)

    def very_verbose(self):
        """Print verbose logging messages, with dynamic memory breakdown"""
        self.level(output=1, notes=1, warnings=1, errors=1, memory=2)

    def message(self, routine, message):
        """Print an informative message to the log"""
        if self.output:
            self.__wrterr(routine, '_', message)

    def warning(self, routine, message):
        """Print a warning message to the log"""
        if self.warnings:
            self.__wrterr(routine, 'W', message)

    def error(self, routine, message):
        """Print an error message to the log"""
        if self.errors:
            self.__wrterr(routine, 'E', message)
        raise ModellerError, message

    def write(self, text):
        """Write directly to the logfile; by default calls sys.stdout.write"""
        sys.stdout.write(text)

    def __wrterr(self, routine, code, message):
        if len(routine) > 10:
            routine = routine[:10]
        elif len(routine) < 10:
            routine = routine + '_' * (10 - len(routine))
        _modeller.wrtlog("%s_%s> %s\n" % (routine, code, message))

    def __set_output(self, val):
        _modeller.modset_log(0, val)
    def __get_output(self):
        return _modeller.modget_log(0)
    def __set_notes(self, val):
        _modeller.modset_log(1, val)
    def __get_notes(self):
        return _modeller.modget_log(1)
    def __set_warnings(self, val):
        _modeller.modset_log(2, val)
    def __get_warnings(self):
        return _modeller.modget_log(2)
    def __set_errors(self, val):
        _modeller.modset_log(3, val)
    def __get_errors(self):
        return _modeller.modget_log(3)
    def __set_memory(self, val):
        _modeller.modset_log(4, val)
    def __get_memory(self):
        return _modeller.modget_log(4)
    output = property(__get_output, __set_output)
    notes = property(__get_notes, __set_notes)
    warnings = property(__get_warnings, __set_warnings)
    errors = property(__get_errors, __set_errors)
    memory = property(__get_memory, __set_memory)

# Global log object
log = logger()
