/** \file mod_core.h       Core Modeller functions.
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

/* This file is auto-generated: any changes will be lost */

#ifndef __MOD_CORE_H
#define __MOD_CORE_H

#include "mod_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**  Print out TOP errors, if any. */
void top_error(int error_status, int stop_on_error);

/**  Initialize the Modeller system. */
void start_modeller(int *ierr);

/**  Initialize Modeller, check the number of command line arguments
 *   (print a usage message if incorrect) and return the directories
 *   containing Modeller library and dynamic library files. */
void init_cmdline(int numarg, char **libdir2, char **dynlibdir2, int *ierr);

/**  Return the directory containing Modeller .h files. */
char * get_incdir(void);

/**  Return the directory containing Modeller dynamic library files. */
char * get_dynlibdir(void);

/**  Shut down Modeller, at the end of a job. */
void end_modeller(void);

/**  Create and return a new libraries object, tied to the given
 *   scripting language object. */
struct libraries * new_libraries(const void *scriptobj);

/**  Release the memory used by a libraries object. */
void free_libraries(struct libraries *libs);

/**  Get the initial random seed. */
int get_libraries_rand_seed(const struct libraries *libs);

/**  Set the initial random seed. */
void set_libraries_rand_seed(struct libraries *libs, int rand_seed);

/**  Read in most libraries (e.g. residue types, classes) */
void libraries_read_libs(struct libraries *libs, const char *restyp_lib_file, int rand_seed, int *ierr);

/**  Set the current random number state. */
void libraries_randstate_set(struct libraries *libs, const int state[158]);

/**  Get the current random number state. */
void libraries_randstate_get(const struct libraries *libs, int **stateout, int *n_stateout);

/**  Get the next random number between 0 and 1. */
float random_number(struct libraries *libs);

/**  Perturb the random number generator by some amount, n. */
void random_perturb(struct libraries *libs, int n);

/**  Clustering. */
void principal_components(const char *matrix_file, const char *file, int *ierr);

/**  Clustering. */
void dendrogram(const char *matrix_file, float cluster_cut, int *ierr);

/**  Read residue type file. */
void read_restyp_lib(struct libraries *libs, const char *restyp_lib_file, int *ierr);

/** Make a database of PSSMs */
void make_pssmdb(const struct libraries *libs, const char *profile_list_file, const char *profile_format, const char *rr_file, float matrix_offset, float matrix_scaling_factor, const char *pssmdb_name, const char *pssm_weights_type, int *ierr);

/**  Create and return a new group_restraints object, tied to the given
 *   scripting language object. */
struct group_restraints * new_group_restraints(const void *scriptobj);

/**  Release the memory used by a group_restraints object. */
void free_group_restraints(struct group_restraints *gprsr);

/**  Read group restraint parameters. */
void read_group_restraints(struct group_restraints *gprsr, const struct libraries *libs, const char *file, int *ierr);

/**  Clear group restraint parameters. */
void clear_group_restraints_param(struct group_restraints *gprsr);

/**  Read atom classes for group restraints. */
void read_atom_classes(struct group_restraints *gprsr, const char *atom_classes_file, int *ierr);

/**  Create and return a new alignment object, tied to the given
 *   scripting language object. */
struct alignment * new_alignment(const void *scriptobj);

/**  Release the memory used by an alignment object. */
void free_alignment(struct alignment *aln);

/**  Get the alignment code of the indx'th sequence. */
char * alignment_codes_get(const struct alignment *aln, int indx);

/**  Set the alignment code of the indx'th sequence. */
void alignment_codes_set(struct alignment *aln, int indx, const char *code);

/**  Get the atom file of the indx'th sequence. */
char * alignment_atom_files_get(const struct alignment *aln, int indx);

/**  Set the atom file of the indx'th sequence. */
void alignment_atom_files_set(struct alignment *aln, int indx, const char *atom_files);

/**  Get the indx'th comment. */
char * alignment_comment_get(const struct alignment *aln, int indx);

/**  Set the indx'th comment. */
void alignment_comment_set(struct alignment *aln, int indx, const char *val);

/**  Set the number of comments. */
void alignment_ncomment_set(struct alignment *aln, int val);

/**  Get the index of the named sequence. */
int find_alignment_code(const struct alignment *aln, const char *code);

/**  Copy one structure to another. */
/**  Copy one sequence to another. */
/**  Copy one alignment sequence to another. */
/**  Delete the sequence(s) from the alignment. */
void alignment_del_seq(struct alignment *aln, const int indices[], int n_indices);

/**  Check to make sure the seq'th sequence in the alignment matches the
 *   given model. */
void chk_aln_model(const struct alignment *aln, int seq, const struct model *mdl, const struct libraries *libs, int *ierr);

/**  Should structural information be read in for this sequence? */
mbool alignment_has_structure(struct alignment *aln, int iseq);

/**  Read a single template structure from file. */
void read_template_structure(struct alignment *aln, int iseq, const struct io_data *io, struct libraries *libs, int *ierr);

/**  Get the residue range of the next insertion in the last sequence in
 *   the alignment. */
void get_next_insertion(const struct alignment *aln, int pos, int *pos_out, int *ins_st, int *ins_end, int minlength, int maxlength, int extension);

/**  Get the residue range of the next deletion in the last sequence in
 *   the alignment. */
void get_next_deletion(const struct alignment *aln, int pos, int *pos_out, int *ins_st, int *ins_end, int extension);

/**  Edit overhangs in alignment. */
void edit_alignment(struct alignment *aln, const struct io_data *io, const struct libraries *libs, int overhang, const char edit_align_codes[], int edit_align_codes_len, int n_edit_align_codes, const char base_align_codes[], int base_align_codes_len, int n_base_align_codes, int min_base_entries, int *ierr);

/**  Align two or more sequences/structures of proteins. */
void salign(struct alignment *aln, const struct io_data *io, struct libraries *libs, const char *residue_type2, mbool no_ter, int overhang, int off_diagonal, float matrix_offset, const float gap_penalties_1d[2], const float gap_penalties_2d[9], const float gap_penalties_3d[2], const float feature_weights[6], const float rms_cutoffs[11], mbool fit, int surftyp, mbool fit_on_first, mbool gap_function, int align_block, int max_gap_length, const char *align_what, mbool read_weights, mbool write_weights, const char *input_weights_file, const char *output_weights_file, mbool weigh_sequences, float smooth_prof_weight, const float fix_offsets[5], mbool substitution, const char *comparison_type, const char *matrix_comparison, const char *alignment_type, const char edit_file_ext[2], int edit_file_ext_len, const char *weights_type, float *aln_score, mbool similarity_flag, const char *bkgrnd_prblty_file, mbool ext_tree, const char *dendrogram_file, float matrix_scaling_factor, mbool auto_overhang, float overhang_factor, int overhang_auto_limit, mbool local_alignment, mbool improve_alignment, const char *fit_atoms, const char *output, mbool write_whole_pdb, mbool current_directory, mbool write_fit, mbool fit_pdbnam, const char *rr_file, int n_subopt, float subopt_offset, mbool align3d_trf, mbool normalize_pp_scores, float gap_gap_score, float gap_residue_score, float *qscore, int nsegm, float matrix_offset_3d, int *ierr);

/**  Align two or more sequences. */
void malign(struct alignment *aln, const struct libraries *libs, const char *rr_file, int off_diagonal, mbool local_alignment, float matrix_offset, int overhang, int align_block, const float gap_penalties_1d[2], int *ierr);

/**  Compare */
void compare(struct alignment *aln, const struct energy_data *edat, const struct io_data *io, struct libraries *libs, int compare_mode, mbool fit, const char *fit_atoms, const char *matrix_file, const char *output, mbool asgl_output, mbool refine_local, const float rms_cutoffs[11], const char distance_atoms[2], int distance_atoms_len, int *ierr);

/**  Read alignment */
void read_alignment(struct alignment *aln, const struct io_data *io, const struct libraries *libs, const char align_codes[], int align_codes_len, int n_align_codes, const char atom_files[], int atom_files_len, int n_atom_files, const char *file, mbool remove_gaps, const char *alignment_format, mbool rewind_file, mbool close_file, int *end_of_file, int *ierr);

/**  Delete alignment */
void delete_alignment(struct alignment *aln);

/**  Write alignment to file. */
void write_alignment(struct alignment *aln, const struct libraries *libs, const char *file, const char *alignment_format, const char *alignment_features, int align_block, mbool align_alignment, int *ierr);

/**  Align two (blocks of) sequences. */
void align(struct alignment *aln, const struct libraries *libs, int off_diagonal, int max_gap_length, mbool local_alignment, float matrix_offset, const float gap_penalties_1d[2], mbool read_weights, mbool write_weights, int n_subopt, float subopt_offset, mbool weigh_sequences, float smooth_prof_weight, const char *align_what, const char *weights_type, const char *input_weights_file, const char *output_weights_file, const char *rr_file, int overhang, int align_block, int *ierr);

/**  Align two structures. */
void align3d(struct alignment *aln, const struct io_data *io, struct libraries *libs, int off_diagonal, int overhang, mbool local_alignment, float matrix_offset, const float gap_penalties_3d[2], mbool fit, const char *fit_atoms, mbool align3d_trf, const char *output, mbool align3d_repeat, int *ierr);

/**  Describe proteins. */
void describe(struct alignment *aln, const struct io_data *io, struct libraries *libs, int *ierr);

/**  Compare sequences in alignment. */
void sequence_comparison(const struct alignment *aln, struct model *mdl, const struct libraries *libs, const char *rr_file, const char *matrix_file, const char *variability_file, int max_gaps_match, int *ierr);

/**  Align two or more structures. */
void malign3d(struct alignment *aln, const struct io_data *io, struct libraries *libs, mbool no_ter, int off_diagonal, int overhang, mbool local_alignment, float matrix_offset, const float gap_penalties_3d[2], mbool fit, const char *fit_atoms, const char *output, mbool write_whole_pdb, mbool current_directory, mbool write_fit, const char edit_file_ext[2], int edit_file_ext_len, int *ierr);

/**  Copy model sequence and coordinates to alignment. */
void sequence_to_ali(struct alignment *aln, struct model *mdl, const struct libraries *libs, const char *atom_files, const char *align_codes);

/**  Compare two alignments */
void compare_alignments(const struct alignment *aln, const struct alignment *aln2, int *ierr);

/**  Consensus sequence alignment. */
void align_consensus(struct alignment *aln, const struct libraries *libs, int align_block, const float gap_penalties_1d[2], int max_gap_length, mbool read_weights, mbool write_weights, mbool weigh_sequences, const char *input_weights_file, const char *output_weights_file, const char *weights_type, float smooth_prof_weight, int *ierr);

/**  Check alignment for modeling. */
void check_alignment(struct alignment *aln, const struct io_data *io, struct libraries *libs, int *ierr);

/**  Align sequences with structures. */
void align2d(struct alignment *aln, const struct io_data *io, struct libraries *libs, int overhang, int align_block, const char *rr_file, const char *align_what, int off_diagonal, int max_gap_length, mbool local_alignment, float matrix_offset, const float gap_penalties_1d[2], const float gap_penalties_2d[9], int surftyp, mbool fit, const float fix_offsets[5], mbool read_weights, mbool write_weights, const char *input_weights_file, const char *output_weights_file, int n_subopt, float subopt_offset, mbool read_profile, const char *input_profile_file, mbool write_profile, const char *output_profile_file, mbool weigh_sequences, float smooth_prof_weight, const char *weights_type, int *ierr);

/**  Align segments. */
void segment_matching(struct alignment *aln, struct libraries *libs, const char *rr_file, const char *file, int align_block, const int min_loop_length[], int n_min_loop_length, const int segment_shifts[], int n_segment_shifts, const int segment_growth_n[], int n_segment_growth_n, const int segment_growth_c[], int n_segment_growth_c, float segment_cutoff, int segment_report, const char *root_name, const char *file_id, const char *file_ext, int *ierr);

/**  Calculate percentage sequence identities. */
void id_table(const struct alignment *aln, const char *matrix_file, int *ierr);

/**  Transfer residue properties of predicted secondary structure
 *   from one sequence to all other sequences. */
void transfer_res_prop(struct alignment *aln, int iseq);

/**  Add a sequence (given by one-letter codes) to an alignment. */
void append_sequence(struct alignment *aln, const char *newseq, const struct libraries *libs, int *ierr);

/**  Create and return a new model object, tied to the given
 *   scripting language object. */
struct model * new_model(const void *scriptobj);

/**  Release the memory used by a model object. */
void free_model(struct model *mdl);

/**  Set the group_restraints object used by the model. */
void model_group_restraints_set(struct model *mdl, const struct libraries *libs, const struct group_restraints *val);

/**  Remove any group_restraints object from the model. */
void model_group_restraints_unset(struct model *mdl, const struct libraries *libs);

/**  Get the index of a named atom. */
int indxatm2(const char *atm, const struct model *mdl, int *ierr);

/**  Get the index of a named residue. */
int iresind(const char *res, const struct model *mdl);

/**  Return the next set of atom indices which matches the given residue
 *   type, atom names, and residue offsets. */
void find_atoms(const struct model *mdl, const char *resnam, const char atms[], int atms_len, int n_atms, const int resoffs[], int n_resoffs, int start, int *ires, int **indatm, int *n_indatm, const struct libraries *libs);

/**  Return the next set of atom indices which defines the given dihedral
 *   type (phi, psi, omega, chi12345). */
void find_dihedrals(const struct model *mdl, const char *resnam, int idiht, int start, int *ires, int **indatm, int *n_indatm, const struct libraries *libs);

/** Calculate the mainchain RMSDs */
void fast_rmsd(const struct model *mdl, const struct model *mdl2, float *rmsd, int *ierr);

/**  Fetch sequences from PDB file. */
void make_chains(struct model *mdl, const struct libraries *libs, const char *file, const char *structure_types, float minimal_resolution, int minimal_chain_length, int max_nonstdres, mbool chop_nonstd_terminii, int minimal_stdres, const char *alignment_format, int *ierr);

/**  Define a random surface patch of atoms. */
void make_region(struct model *mdl, struct libraries *libs, float atom_accessibility, int region_size, int *ierr);

/**  Guess model disulfides from model structure. */
void patch_ss_model(struct model *mdl, const struct libraries *libs, int *ierr);

/**  Write derivative model data. */
void write_data(struct model *mdl, const struct energy_data *edat, const struct libraries *libs, int surftyp, float neighbor_cutoff, int accessibility_type, const char *output, const char *file, float probe_radius, float psa_integration_step, const char *dnr_accpt_lib, int *ierr);

/**  Guess model disulfides from templates. */
void patch_ss_templates(struct model *mdl, struct alignment *aln, const struct io_data *io, struct libraries *libs, int *ierr);

/**  Read the atom model file; READ_MODEL */
void read_model(struct model *mdl, const struct io_data *io, struct libraries *libs, const char *file, const char *model_format, const char model_segment[2], int model_segment_len, int *ierr);

/**  Write the model */
void write_model(const struct model *mdl, const struct libraries *libs, const int sel1[], int n_sel1, const char *file, const char *model_format, mbool no_ter, mbool write_all_atoms, int *ierr);

/**  Patch the MODEL */
void patch(struct model *mdl, const struct libraries *libs, const char *residue_type, const int residue_ids[], int n_residue_ids, int *ierr);

/**  Transfer residue numbers */
void transfer_res_numb(struct model *mdl, struct model *mdl2, const struct alignment *aln, const struct libraries *libs, int *ierr);

/**  Build model coordinates from topology. */
void build_model(struct model *mdl, struct libraries *libs, const char *build_method, mbool initialize_xyz, int *ierr);

/**  Clear model topology. */
void clear_model_topology(struct model *mdl);

/**  Generate model topology. */
void generate_topology(struct model *mdl, struct alignment *aln, const struct io_data *io, struct libraries *libs, int iseq, mbool patch_default, int *ierr);

/**  Standardize order of model atoms. */
void reorder_atoms(struct model *mdl, struct libraries *libs, int *ierr);

/**  Copy templates' coordinates to the model. */
void transfer_xyz(struct model *mdl, struct alignment *aln, const struct io_data *io, struct libraries *libs, float cluster_cut, const char *cluster_method, int *ierr);

/**  Center and orient the model. */
void orient_model(struct model *mdl, float rotation[9], float translation[3], int *ierr);

/**  Rename model segments and residues. */
void rename_segments(struct model *mdl, const char segment_ids[], int segment_ids_len, int n_segment_ids, const int renumber_residues[], int n_renumber_residues, int *ierr);

/**  Color model according to alignment. */
void color_aln_model(struct model *mdl, const struct alignment *aln, int *ierr);

/**  Standardize certain dihedral angles. */
void iupac_model(struct model *mdl, const struct libraries *libs, int *ierr);

/**  Define similar segments. */
void define_symmetry(struct model *mdl, const int sel2[], int n_sel2, const int sel3[], int n_sel3, const mbool add_symmetry[2], float symmetry_weight, int *ierr);

/**  Calculate protein volume. */
void volume(struct model *mdl, const struct energy_data *edat, const struct libraries *libs, const char *file, const char *output, float grid_unit, int number_of_steps, mbool orient, int *ierr);

/**  Calculate protein cavity volume. */
void volume_cavity(struct model *mdl, const struct energy_data *edat, const struct libraries *libs, const char *file, const char *output, float grid_unit, int number_of_steps, float probe_radius, float rcutp, float rcutl, float vmin, float rlink, mbool orient, mbool accuracy_border, int *ierr);

/**  Create and return a new sequence_db object, tied to the given
 *   scripting language object. */
struct sequence_db * new_sequence_db(const void *scriptobj);

/**  Release the memory used by a sequence_db object. */
void free_sequence_db(struct sequence_db *sdb);

/**  Get the alignment code of the indx'th sequence. */
char * sequence_db_code_get(const struct sequence_db *sdb, int indx);

/**  Set the alignment code of the indx'th sequence. */
void sequence_db_code_set(struct sequence_db *sdb, int indx, const char *code);

/**  Get the protein type of the indx'th sequence. */
char * sequence_db_prottyp_get(const struct sequence_db *sdb, int indx);

/**  Set the protein type of the indx'th sequence. */
void sequence_db_prottyp_set(struct sequence_db *sdb, int indx, const char *prottyp);

/**  Get the residue integer type. */
int sequence_db_restype_get(const struct sequence_db *sdb, int seq, int indx);

/**  Set the residue integer type. */
void sequence_db_restype_set(struct sequence_db *sdb, int seq, int indx, int val);

/**  Cluster sequences by sequence-identity. */
void seqfilter(const struct sequence_db *sdb, const struct libraries *libs, const float gap_penalties_1d[2], float matrix_offset, const char *rr_file, int seqid_cut, int max_diff_res, const char *output_grp_file, const char *output_cod_file, int *ierr);

/**  Read a database of sequences. */
void read_sequence_db(struct sequence_db *sdb, const struct libraries *libs, const char *chains_list, const char *seq_database_file, const char *seq_database_format, mbool clean_sequences, const int minmax_db_seq_len[2], int *ierr);

/**  Write a database of sequences. */
void write_sequence_db(struct sequence_db *sdb, const struct libraries *libs, const char *chains_list, const char *seq_database_file, const char *seq_database_format, int *ierr);

/**  Convert a database of sequences to binary format. */
void convert_sequence_db(struct sequence_db *sdb, const struct libraries *libs, const char *chains_list, const char *seq_database_file, const char *seq_database_format, const char *outfile, mbool clean_sequences, const int minmax_db_seq_len[2], int *ierr);

/**  Search for similar sequences. */
void sequence_search(struct sequence_db *sdb, struct alignment *aln, const struct io_data *io, struct libraries *libs, int search_randomizations, int search_top_list, int off_diagonal, int overhang, const float gap_penalties_1d[2], const float signif_cutoff[2], const char *rr_file, float matrix_offset, float fast_search_cutoff, mbool data_file, const char *search_group_list, const char *search_sort, const char *output, const char *alignment_features, const char *seq_database_file, mbool local_alignment, mbool fast_search, int *ierr);

/**  Create and return a new profile object, tied to the given
 *   scripting language object. */
struct profile * new_profile(const void *scriptobj);

/**  Release the memory used by a profile object. */
void free_profile(struct profile *prf);

/**  Get the profile sequence alignment code. */
char * get_profile_code(const struct profile *prf, int indx);

/**  Set the profile sequence alignment code. */
void set_profile_code(struct profile *prf, int indx, const char *code);

/**  Get the profile sequence protein type. */
char * get_profile_prottyp(const struct profile *prf, int indx);

/**  Set the profile sequence protein type. */
void set_profile_prottyp(struct profile *prf, int indx, const char *prottyp);

/**  Build a profile for a given sequence or alignment. */
void build_profile(struct profile *prf, const struct sequence_db *sdb, const struct libraries *libs, const float gap_penalties_1d[2], float matrix_offset, const char *rr_file, int n_prof_iterations, float max_aln_evalue, float matrix_scaling_factor, mbool check_profile, mbool output_scores, const char *output_score_file, mbool gaps_in_target, mbool score_statistics, const char *pssm_weights_type, mbool write_pssm, const char *pssm_file, int *ierr);

/**  Compare a target profile against a database of profiles. */
void profile_profile_scan(const struct profile *prf, const struct pssmdbobj *pssmdb, const struct libraries *libs, const char *profile_list_file, float matrix_offset, const char *profile_format, const char *rr_file, const float gap_penalties_1d[2], float matrix_scaling_factor, float max_aln_evalue, const char *aln_base_filename, mbool score_statistics, mbool output_alignments, mbool output_scores, const char *output_score_file, const char *pssm_weights_type, mbool write_summary, const char *summary_file, float ccmatrix_offset, int *ierr);

/**  Read a profile of a sequence. */
void read_profile(struct profile *prf, const struct libraries *libs, const char *file, const char *profile_format, int *ierr);

/**  Write a profile. */
void write_profile(struct profile *prf, const struct libraries *libs, const char *file, int n_prof_iterations, const float gap_penalties_1d[2], float matrix_offset, const char *profile_format, const char *rr_file, int *ierr);

/**  Convert alignment to profile format. */
void aln_to_prof(const struct alignment *aln, struct profile *prf, int *ierr);

/**  Convert profile to alignment format. */
void prof_to_aln(const struct profile *prf, struct alignment *aln, const struct libraries *libs);

/**  Delete all restraints. */
void clear_restraints(struct model *mdl);

/**  Unselect all restraints. */
void unpick_all_restraints(struct restraints *rsr);

/**  Add a single restraint to the list. */
void add_single_restraint(struct restraints *rsr, int iform, int group, const int iftyp[], int n_iftyp, const int modal[], int n_modal, const int natm[], int n_natm, const int indatm[], int n_indatm, const float pcsr[], int n_pcsr, mbool use_array, int *array_index, int *ierr);

/**  Get one restraint. */
void get_single_restraint(const struct restraints *rsr, int indx, int *group, int **modal, int *n_modal, int **indatm, int *n_indatm, int **feat, int *n_feat, float **param, int *n_param, int *ierr);

/**  Read spatial restraints. */
void read_restraints(struct model *mdl, const char *file, int *ierr);

/**  Write current restraints */
void write_restraints(struct model *mdl, const char *file, int *ierr);

/**  Make restraints. */
void make_restraints(struct model *mdl, struct energy_data *edat, struct alignment *aln, const struct io_data *io, struct libraries *libs, const int sel1[], int n_sel1, const int sel2[], int n_sel2, const int sel3[], int n_sel3, const int residue_span_range[2], int residue_grouping, const char *restraint_type, int restraint_sel_atoms, int restraint_group, const char *basis_pdf_weight, int distance_rsr_model, float maximal_distance, float basis_relative_weight, mbool spline_on_site, mbool residue_span_sign, mbool intersegment, mbool dih_lib_only, float spline_dx, int spline_min_points, float spline_range, int mnch_lib, int accessibility_type, const float restraint_stdev[2], const float restraint_stdev2[3], int surftyp, const char distance_atoms[2], int distance_atoms_len, float distngh, int *ierr);

/**  Make alpha (helix) secondary structure restraints. */
void make_alpha_restraints(struct model *mdl, const int residue_ids[2], const struct libraries *libs, int *ierr);

/**  Make strand secondary structure restraints. */
void make_strand_restraints(struct model *mdl, const int residue_ids[2], const struct libraries *libs, int *ierr);

/**  Make sheet secondary structure restraints. */
void make_sheet_restraints(struct model *mdl, const int atom_ids[2], int sheet_h_bonds, int *ierr);

/**  Pick restraints for selected atoms. */
void pick_restraints(struct model *mdl, const int sel1[], int n_sel1, const int residue_span_range[2], int restraint_sel_atoms, const float restraints_filter[], int n_restraints_filter, int *ierr);

/**  Remove unselected restraints. */
void condense_restraints(struct model *mdl);

/**  Unselect restraints. */
void unpick_restraints(struct model *mdl, const int atom_ids[], int n_atom_ids, int *ierr);

/**  Add a restraint. */
void add_restraint(struct model *mdl, const float restraint_parameters[], int n_restraint_parameters, const char atom_ids[], int atom_ids_len, int n_atom_ids, int *ierr);

/**  Renumber mdl2 restraints for mdl. */
void reindex_restraints(struct model *mdl, const struct model *mdl2, int *ierr);

/**  Approximate restraints by splines. */
void spline_restraints(struct model *mdl, struct energy_data *edat, const struct libraries *libs, const int residue_span_range[2], float spline_dx, float spline_range, const int spline_select[3], int spline_min_points, const char *output, int *ierr);

/**  Create and return a new density object, tied to the given
 *   scripting language object. */
struct density * new_density(const void *scriptobj);

/**  Release the memory used by a density object. */
void free_density(struct density *den);

/**  Calculate the forces on the selected atoms in the given model,
 *   resulting purely from the fit of the model to the density. */
void density_forces(struct density *den, struct model *mdl, float *ccf);

/**  Read an EM density file */
void read_density(struct density *den, const char *file, const char *em_density_format, int em_map_size, const char *filter_type, float voxel_size, float resolution, const float filter_values[2], const char *density_type, float px, float py, float pz, const char *cc_func_type, int *ierr);

/**  EM fitting by grid search */
void em_grid_search(const struct density *den, const char *em_density_format, int num_structures, const char *dock_order, const char *start_type, const char *translate_type, int number_of_steps, float angular_step_size, float temperature, int best_docked_models, const char *em_fit_output_file, const char em_pdb_name[], int em_pdb_name_len, int n_em_pdb_name, const int chains_num[], int n_chains_num, int *ierr);

/**  Set residue span range from user-specified value or schedule definition. */
void update_schedule(struct schedule *sched, const int residue_span_range[2], int *nrang1, int *nrang2, int *ierr);

/**  Check whether there is a schedule in memory. */
void check_schedule(struct schedule *sched, int *ierr);

/**  Get the schedule's current optimizer. */
int get_schedule_optimizer(const struct schedule *sch);

/**  Create and return a new energy_data object. */
struct energy_data * new_energy_data(void);

/**  Release the memory used by an energy_data object. */
void free_energy_data(struct energy_data *ene);

/**  Set an energy_data object's associated EM density. */
void set_edata_density(struct energy_data *ene, const struct density *den);

/**  Unset an energy_data object's associated EM density. */
void unset_edata_density(struct energy_data *ene);

/**  Set an energy_data object's members. */
void set_energy_data(struct energy_data *ene, float contact_shell, float relative_dielectric, float radii_factor, float sphere_stdv, float update_dynamic, int nonbonded_sel_atoms, int nlogn_use, mbool covalent_cys, mbool dynamic_pairs, mbool dynamic_sphere, mbool dynamic_coulomb, mbool dynamic_lennard, mbool dynamic_modeller, mbool dynamic_access, mbool dynamic_gbsa, const float lennard_jones_switch[2], const float coulomb_switch[2], const mbool excl_local[4], int solvent_model);

/**  Create and return a new io_data object. */
struct io_data * new_io_data(void);

/**  Release the memory used by an io_data object. */
void free_io_data(struct io_data *io);

/**  Set members of an io_data object. */
void set_io_data(struct io_data *io, mbool hydrogen, mbool hetatm, mbool water, const char *atom_files_directory);

/**  Clear all parameter information. */
void clear_parameters(struct parameters *prm);

/**  Return True if parameters have been read in already. */
mbool parameters_read(const struct parameters *prm);

/**  Read parameters from file. */
void new_read_parameters(struct parameters *prm, const struct libraries *libs, const char *file, int *ierr);

/**  Clear all topology information. */
void clear_topology(struct topology *tpl, const struct libraries *libs);

/**  Return True if the topology library has already been read. */
mbool topology_read(const struct topology *tpl);

/**  Read residue topology library from file. */
void read_topology(struct topology *tpl, const struct libraries *libs, const char *file, int *ierr);

/**  Write residue topology library to file. */
void write_topology_model(const struct topology *tpl, const struct libraries *libs, const char *file, int *ierr);

/**  Make a subset topology library. */
void make_topology_model(struct topology *tpl, int *ierr);

/**  Get the atom type. */
char * get_coord_atmnam(const struct coordinates *cd, int indx);

/**  Get the PDB residue number of the given residue. */
char * get_coord_resnum(const struct coordinates *cd, int indx);

/**  Set the PDB residue number of the given residue. */
void set_coord_resnum(struct coordinates *cd, int indx, const char *val);

/**  Get the current value of a dihedral (in degrees) of the given type.
 *   \note Does not currently account for disulfide bridges. */
float coord_dihedral_get(const struct coordinates *cd, const struct sequence *seq, const struct libraries *libs, int idihtyp, int indx, int *ierr);

/**  Given a dihedral value in degrees, return the dihedral class. */
int coord_dihclass_get(const struct sequence *seq, const struct libraries *libs, int idihtyp, float dih, int indx);

/**  Return True iff the given residue has the given dihedral type. */
mbool coord_has_dihedral(const struct coordinates *cd, const struct sequence *seq, const struct libraries *libs, int idihtyp, int indx, int *ierr);

/**  Get the atom indices of the given dihedral type. */
void coord_dihatoms_get(const struct coordinates *cd, const struct sequence *seq, const struct libraries *libs, int idihtyp, int indx, int **indatm, int *n_indatm, int *ierr);

/**  Create and return a new saxsdata object. */
struct saxsdata * new_saxsdata(void);

/**  Release the memory used by a saxsdata object. */
void free_saxsdata(struct saxsdata *saxsd);

/**  Calculate SAXS intensity from model.
 *   last change 10/06/06 FF - now works on selection */
void saxs_intens(const struct model *mdl, struct saxsdata *saxsd, const int indatm[], int n_indatm, const char *filename, mbool fitflag, int *ierr);

/**  Initialization of SAXS data.
 *   In this routine the SAXS parameters are set, the sampling in reciprocal
 *   space is determined and the resulting scattering factors are computed.
 *   last change 04/10/06
 *   10/10/06 FF - note: sel1 and n_sel1 have to be called like that to be
 *                 passed correctly ... */
void ini_saxs(struct saxsdata *saxsd, const struct model *mdl, const int sel1[], int n_sel1, double s_min, double s_max, int maxs, int nmesh, int natomtyp, const char *represtyp, const char *filename, const char *wswitch, double s_hybrid, double s_low, double s_hi, const char *spaceflag, double rho_solv, mbool use_lookup, int nr, double dr, mbool use_offset, int *ierr);

/**  Read in experimental (or simulated) SAXS data */
void saxs_read(struct saxsdata *saxsd, const char *filename, int *ierr);

/**  Insert a new saxsdata pointer before |indx|. */
void new_saxsdata_pt(struct energy_data *edat, int indx, const struct saxsdata *saxsd);

/**  Remove the saxsdata pointer at position |indx| in the list. */
void del_saxsdata_pt(struct energy_data *edat, int indx);

/**  Create and return a new PSSM DB object, tied to the given scripting
 *   language object. */
struct pssmdbobj * new_pssmdbobj(const void *scriptobj);

/**  Release the memory used by a PSSM DB object. */
void free_pssmdbobj(struct pssmdbobj *psm);

/** Read in a database of PSSMs */
void read_pssmdb(struct pssmdbobj *psm, const char *pssmdb_name, const char *pssmdb_format, int *ierr);

/**  Return True iff the given feature type is an angle. */
mbool isangle(int ifeat, int *ierr);

/**  Evaluate the given feature type on the given atoms. */
float feature(const struct model *mdl, const int indatm[], int n_indatm, int iftyp, int *ierr);

/**  Evaluate the first derivatives of the given feature. */
void featder(const struct model *mdl, const int indatm[], int n_indatm, int iftyp, float feat, float dervx[], float dervy[], float dervz[], int *ierr);

/**  Calculate the distance between the current feature value and the
 *   mean (dealing correctly with periodic features). */
float deltaf(float feat, float rmean, int iftyp, int *ierr);

/**  Return the center of mass (unweighted) of the given selection. */
void get_selection_com(const struct model *mdl, const int indatm[], int n_indatm, float *cx, float *cy, float *cz);

/**  Translate all atoms in the given selection by vector. */
void translate_selection(struct model *mdl, const int indatm[], int n_indatm, const float vector[3]);

/**  Rotate the given selection about an axis through the origin,
 *   by the given angle (in degrees). */
void rotate_axis_selection(struct model *mdl, const int indatm[], int n_indatm, const float axis[3], float angle);

/**  Transform the selection coordinates with the given matrix. */
void transform_selection(struct model *mdl, const int indatm[], int n_indatm, const float matrix[9]);

/**  Return a new selection containing only atoms of the given
 *   space-separated types. */
void selection_atom_types(const struct model *mdl, const int indatm[], int n_indatm, const char *atom_types, int **newindatm, int *n_newindatm);

/**  Return a new selection containing only atoms in residues of the
 *   given space-separated types. */
void selection_residue_types(const struct model *mdl, const int indatm[], int n_indatm, const char *residue_types, int **newindatm, int *n_newindatm, const struct libraries *libs);

/**  Return a new selection containing only atoms in HETATM residues. */
void selection_het_residues(const struct model *mdl, const int indatm[], int n_indatm, int **newindatm, int *n_newindatm, const struct libraries *libs);

/**  Return a new selection containing only atoms in residue types with
 *   no defined topology. */
void selection_no_topology(const struct model *mdl, const int indatm[], int n_indatm, int **newindatm, int *n_newindatm, const struct libraries *libs);

/**  Return a new selection containing only atoms in standard residue
 *   types. */
void selection_std_residues(const struct model *mdl, const int indatm[], int n_indatm, int **newindatm, int *n_newindatm, const struct libraries *libs);

/**  Return a new selection containing all atoms within the given radius
 *   of the given point. */
void select_sphere(const struct model *mdl, float x, float y, float z, float radius, int **newindatm, int *n_newindatm);

/**  Return a selection containing all atoms from the given model. */
void select_all(const struct model *mdl, int **newindatm, int *n_newindatm);

/**  Superpose MODEL2 on top of MODEL */
void superpose(struct model *mdl, struct model *mdl2, const struct alignment *aln, const struct libraries *libs, const int sel1[], int n_sel1, const char *swap_atoms_in_res, const char *reference_atom, float reference_distance, mbool superpose_refine, mbool fit, mbool refine_local, float rms_cutoff, float *rms_final, float *drms_final, float rotation[9], float translation[3], int *num_equiv_pos, int *num_equiv_dist, int *ierr);

/**  Report energy */
void energy(struct model *mdl, struct energy_data *edat, const struct libraries *libs, const int sel1[], int n_sel1, mbool asgl_output, mbool normalize_profile, const int residue_span_range[2], const char *output, const char *file, int smoothing_window, float *molpdf, const float viol_report_cut[], int n_viol_report_cut, const float viol_report_cut2[], int n_viol_report_cut2, const float schedule_scale[], int n_schedule_scale, float **violtyp, int *n_violtyp, int *ierr);

/**  Get just the energy (no derivatives or printouts). */
void get_objfunc(struct model *mdl, struct energy_data *edat, const struct libraries *libs, const int sel1[], int n_sel1, const int residue_span_range[2], float *molpdf, const float schedule_scale[], int n_schedule_scale, int *ierr);

/**  Calculate energy RMS and profile for restraints of the given physical
 *   type. */
void rms_profile(struct model *mdl, struct energy_data *edat, const struct libraries *libs, const int sel1[], int n_sel1, const int residue_span_range[2], mbool energy_profile, mbool viol_profile, int iphytyp, const float schedule_scale[], int n_schedule_scale, float **profres, int *n_profres, int **nprofres, int *n_nprofres, float *min_rms, float *heavy_rms, int *ierr);

/**  Change model structure by rotation around dihedral angles */
void rotate_dihedrals(struct model *mdl, struct libraries *libs, const int sel1[], int n_sel1, float deviation, const char *change, const char dihedrals[], int dihedrals_len, int n_dihedrals, int *ierr);

/**  Randomize selected coordinates. */
void randomize_xyz(struct model *mdl, struct libraries *libs, const int sel1[], int n_sel1, float deviation, int *ierr);

/**  Test code self-consistency. */
void debug_function(struct model *mdl, struct energy_data *edat, const struct libraries *libs, const int sel1[], int n_sel1, const int residue_span_range[2], const float debug_function_cutoff[3], mbool detailed_debugging, const float schedule_scale[], int n_schedule_scale, int *ierr);

/**  Select atoms violating restraints. */
void pick_hot_atoms(struct model *mdl, struct energy_data *edat, const struct libraries *libs, const int sel1[], int n_sel1, int **sel1out, int *n_sel1out, const int residue_span_range[2], float pick_hot_cutoff, const float viol_report_cut[], int n_viol_report_cut, const float schedule_scale[], int n_schedule_scale, int *ierr);

/**  Reset model information. */
void unbuild_model(struct model *mdl, const int sel1[], int n_sel1);

/**  Create and return a new md_optimizer object, tied to the given
 *   scripting language object. */
struct md_optimizer * new_md_optimizer(const void *scriptobj);

/**  Release the memory used by an md_optimizer object. */
void free_md_optimizer(struct md_optimizer *opt);

/**  One step of MD optimization */
void md_optimize(struct md_optimizer *mdopt, struct model *mdl, struct energy_data *edat, struct libraries *libs, const int sel1[], int n_sel1, mbool init_velocities, float temperature, float md_time_step, float cap_atom_shift, int equilibrate, int max_iterations, const int residue_span_range[2], const char *md_return, float guide_factor, float guide_time, float friction, const char *output, float *molpdf, int *ierr);

/**  Get the guide force on the indx'th atom of the model. */
void mdopt_guide_f_get(const struct md_optimizer *mdopt, int indx, float *x, float *y, float *z);

/**  Create and return a new cg_optimizer object, tied to the given
 *   scripting language object. */
struct cg_optimizer * new_cg_optimizer(const void *scriptobj);

/**  Release the memory used by a cg_optimizer object. */
void free_cg_optimizer(struct cg_optimizer *opt);

/**  One step of CG optimization */
void cg_optimize(struct cg_optimizer *cgopt, struct model *mdl, struct energy_data *edat, struct libraries *libs, const int sel1[], int n_sel1, float min_atom_shift, int max_iterations, const int residue_span_range[2], const char *output, float *molpdf, int *ierr);

/**  Create and return a new state_optimizer object, tied to the given
 *   scripting language object. */
struct state_optimizer * new_state_optimizer(const void *scriptobj);

/**  Release the memory used by a state_optimizer object. */
void free_state_optimizer(struct state_optimizer *opt);

/**  Prepare for an optimization using this state_optimizer object. */
void state_optimizer_start(struct state_optimizer *opt, struct model *mdl, const struct libraries *libs, struct energy_data *enedata, const int inds[], int n_inds, int *ierr);

/**  Get the current state (e.g. x/y/z coordinates) of the optimizer. */
void get_state_optimizer_state(const struct state_optimizer *opt, float **state, int *n_state);

/**  Set the current state (e.g. x/y/z coordinates) of the optimizer. */
void set_state_optimizer_state(struct state_optimizer *opt, struct energy_data *enedata, const float state[], int n_state, int *ierr);

/**  Calculate the energy and first derivatives of the given state. */
void state_optimizer_energy(struct state_optimizer *opt, struct energy_data *enedata, const float state[], int n_state, float *ene, float **dstate, int *n_dstate, const struct libraries *libs, int *ierr);

/**  Calculate just the energy (no first derivatives) of the given state. */
float state_optimizer_energy_only(struct state_optimizer *opt, struct energy_data *enedata, const float state[], int n_state, const struct libraries *libs, int *ierr);

/**  Increment the state_optimizer object's step counter. */
void state_optimizer_next_step(struct state_optimizer *opt);

/**  Create and return a new qn_optimizer object, tied to the given
 *   scripting language object. */
struct qn_optimizer * new_qn_optimizer(const void *scriptobj);

/**  Release the memory used by a qn_optimizer object. */
void free_qn_optimizer(struct qn_optimizer *opt);

/**  One step of quasi Newton optimization */
void qn_optimize(struct qn_optimizer *qnopt, struct model *mdl, struct energy_data *edat, struct libraries *libs, const int sel1[], int n_sel1, float min_atom_shift, float max_atom_shift, int max_iterations, const int residue_span_range[2], const char *output, float *molpdf, int *ierr);

/**  Get the atom indices of a given rigid body. */
void rigid_body_get(const struct model *mdl, int indx, int **indatm, int *n_indatm);

/**  Set the atom indices of a given rigid body. */
void rigid_body_set(struct model *mdl, int indx, const int indatm[], int n_indatm);

/**  Get the number of rigid bodies. */
int model_nrigid_get(const struct model *mdl);

/**  Set the number of rigid bodies. */
void model_nrigid_set(struct model *mdl, int num);

/**  Get an alignment sequence object. */
struct sequence * alignment_sequence_get(const struct alignment *aln, int indx);

/**  Get the ID of the given segment. */
char * sequence_segid_get(const struct sequence *seq, int indx);

/**  Set the ID of the given segment. */
void sequence_segid_set(struct sequence *seq, int indx, const char *val);

/**  Get the chain index for the given residue index. */
int sequence_chain_for_residue(const struct sequence *seq, int indx);

/**  Get the index of a named segment, or 0 if not found. */
int isegind(const char *segid, const struct sequence *seq);

/**  Get the range of the sequence. */
char * sequence_rng_get(const struct sequence *seq, int indx);

/**  Set the range of the given segment. */
void sequence_rng_set(struct sequence *seq, int indx, const char *val);

/**  Given a residue type, get the internal (CHARMM) residue name
 *   (usually 4-letter). */
char * residue_name_from_type(int restyp, const struct libraries *libs);

/**  Given a residue type, get the PDB residue name (3-letter).
 *   If multiple synonyms are defined, return the first one. */
char * residue_pdbnam_from_type(int restyp, const struct libraries *libs);

/**  Given a residue type, get the one letter residue code. */
char * residue_code_from_type(int restyp, const struct libraries *libs);

/**  Return TRUE iff this residue is a PDB HETATM residue. */
mbool residue_is_hetatm(int restyp, const struct libraries *libs);

/**  Return a residue type from the internal CHARMM name. */
int residue_type_from_name(const char *resnam, const struct libraries *libs);

/**  Return a residue type from a PDB name. */
int residue_type_from_pdbnam(const char *resnam, const struct libraries *libs);

/**  Return a residue type from the one-letter code. */
int residue_type_from_code(const char *resnam, const struct libraries *libs);

/**  Write the header of a CHARMM-style trajectory file. */
void write_traj_header(const struct model *mdl, const char *file, int skip, const int sel[], int n_sel, int *unitnum, int *ierr);

/**  Write one set of coordinates to a CHARMM trajectory file. */
void write_traj_set(const struct model *mdl, const int sel[], int n_sel, int unitnum);

/**  Close a trajectory file. */
void close_traj(int unitnum);

/**  Update the position of a single pseudo atom. */
void update_pseudo_position(struct model *mdl, int indx, int *ierr);

/**  Get the type and real atom indices of a given pseudo atom. */
void pseudo_atom_get(const struct model *mdl, int indx, int *psdtype, int **indatm, int *n_indatm);

/**  Append a single pseudo atom to the end of the list. */
int pseudo_atom_append(struct model *mdl, int typ, const int indatm[], int n_indatm);

/**  Given an atom type, get the CHARMM name. */
char * atom_name_from_type(int atmtyp, const struct libraries *libs, int *ierr);

/**  Get the atom indices of a given excluded pair. */
void excluded_pair_get(const struct model *mdl, int indx, int **indatm, int *n_indatm);

/**  Set the atom indices of a given excluded pair. */
void excluded_pair_set(struct model *mdl, int indx, const int indatm[2]);

/**  Get the number of excluded pairs. */
int model_nexcl_get(const struct model *mdl);

/**  Set the number of excluded pairs. */
void model_nexcl_set(struct model *mdl, int num);

/**  Get the indx'th element of the 1D Fortran INTEGER array. */
int f_int1_get(const struct f_int1_array *ptarr, int indx);

/**  Get a C pointer to the 1D Fortran INTEGER array. */
int * f_int1_pt(const struct f_int1_array *ptarr);

/**  Set the indx'th element of the 1D Fortran INTEGER array. */
void f_int1_set(struct f_int1_array *ptarr, int indx, int val);

/**  Get the indx'th element of the 1D Fortran REAL array. */
float f_float1_get(const struct f_float1_array *ptarr, int indx);

/**  Set the indx'th element of the 1D Fortran REAL array. */
void f_float1_set(struct f_float1_array *ptarr, int indx, float val);

/**  Get the indx'th element of the 1D Fortran REAL(8) array. */
double  f_double1_get(const struct f_double1_array *ptarr, int indx);

/**  Set the indx'th element of the 1D Fortran REAL(8) array. */
void f_double1_set(struct f_double1_array *ptarr, int indx, double val);

/**  Get the indx1,indx2'th element of the 2D Fortran INTEGER array. */
int f_int2_get(const struct f_int2_array *ptarr, int indx1, int indx2);

/**  Set the indx1,indx2'th element of the 2D Fortran INTEGER array. */
void f_int2_set(struct f_int2_array *ptarr, int indx1, int indx2, int val);

/**  Get the indx1,indx2'th element of the 2D Fortran REAL array. */
float f_float2_get(const struct f_float2_array *ptarr, int indx1, int indx2);

/**  Set the indx1,indx2'th element of the 2D Fortran REAL array. */
void f_float2_set(struct f_float2_array *ptarr, int indx1, int indx2, float val);

/**  Get the indx1,indx2'th element of the 2D Fortran REAL(8) array. */
double  f_double2_get(const struct f_double2_array *ptarr, int indx1, int indx2);

/**  Set the indx1,indx2'th element of the 2D Fortran REAL(8) array. */
void f_double2_set(struct f_double2_array *ptarr, int indx1, int indx2, double val);

/**  Get the indx1..3'th element of the 3D Fortran INTEGER array. */
int f_int3_get(const struct f_int3_array *ptarr, int indx1, int indx2, int indx3);

/**  Set the indx1..3'th element of the 3D Fortran INTEGER array. */
void f_int3_set(struct f_int3_array *ptarr, int indx1, int indx2, int indx3, int val);

/**  Get the indx1..3'th element of the 3D Fortran REAL array. */
float f_float3_get(const struct f_float3_array *ptarr, int indx1, int indx2, int indx3);

/**  Set the indx1..3'th element of the 3D Fortran REAL array. */
void f_float3_set(struct f_float3_array *ptarr, int indx1, int indx2, int indx3, float val);

/**  Get an alignment structure object. */
struct structure * alignment_structure_get(const struct alignment *aln, int indx);

/**  Report violations of symmetry restraints. */
void report_symmetry(const struct model *mdl, float deviation);

/**  \file top_act.F90    Compatibility routines, mainly for TOP interface.
 *   Write statement */
void top_write(int io_unit, const char objects[], int objects_len, int n_objects, int *ierr);

/**  Read statement */
void top_read(int io_unit, char **record, int *ierr);

/**  Open statement */
void top_open(int io_unit, const char *objects_file, const char *output_directory, const char *file_status, const char *file_access, int *number_lines, int *ierr);

/**  Close a file */
void top_close(int io_unit);

/**  Terminate Modeller */
void stop(void);

/**  Read schedule file */
void read_schedule(struct model *mdl, const char *file, const float schedule_scale[], int n_schedule_scale, int *ierr);

/**  One variable target function step of optimization */
void optimize(struct model *mdl, struct energy_data *edat, struct libraries *libs, const int sel1[], int n_sel1, int optimization_method, mbool init_velocities, float temperature, float md_time_step, float min_atom_shift, float cap_atom_shift, int trace_output, int equilibrate, int max_iterations, const int residue_span_range[2], const char *md_return, const char *output, float *molpdf, int *ierr);

/**  Pick atoms */
void pick_atoms(struct model *mdl, const struct alignment *aln, const struct libraries *libs, const int sel[], int n_sel, int **selout, int *n_selout, int pick_atoms_set, float sphere_radius, const float selection_slab[5], const int gap_extension[2], const int minmax_loop_length[2], const char *res_types, const char *atom_types, const char *selection_mode, const char *selection_search, const char *selection_status, const char *selection_from, const char sphere_center[2], int sphere_center_len, const char selection_segment[2], int selection_segment_len, int *ierr);

/**  Switch the trace file */
void switch_trace(struct model *mdl, const char *file, const char *output_directory, int *ierr);

/**  Write model 2 */
void write_model2(struct model *mdl2, const struct libraries *libs, const char *file, const char *model_format, mbool no_ter, int *ierr);

/**  Read the model 2 file */
void read_model2(struct model *mdl2, const struct io_data *io, struct libraries *libs, const char *file, const char *model_format, const char model2_segment[2], int model2_segment_len, int *ierr);

/**  Get the default variable target function schedule; DEFAULT_SCHEDULE */
void make_schedule(struct model *mdl, int library_schedule, const int residue_span_range[2], const float schedule_scale[], int n_schedule_scale, int *ierr);

/**  Write schedule file */
void write_schedule(const struct model *mdl, const char *file, const char *output_directory, int *ierr);

/**  Read parameters. */
void read_parameters(struct parameters *prm, struct group_restraints *gprsr, const struct libraries *libs, const char *file, int *ierr);

/**  Read the second alignment; no possibility to add sequences here. */
void read_alignment2(struct alignment *aln2, const struct io_data *io, const struct libraries *libs, const char align_codes2[], int align_codes2_len, int n_align_codes2, const char atom_files2[], int atom_files2_len, int n_atom_files2, const char *file, mbool remove_gaps, const char *alignment_format, mbool rewind_file, mbool close_file, int *end_of_file, int *ierr);

/**  Put all models into alignment. */
void expand_alignment(struct alignment *aln, const int expand_control[5], const char *root_name, const char *file_id, const char *file_ext, int *ierr);

/**  Open a file with Fortran routines.
!
 *   Deprecated; use openf() instead, which uses C routines. */
/**  Write residue number/index correspondence. */
void write_pdb_xref(struct model *mdl, const struct libraries *libs, const char *file, const char model_segment[2], int model_segment_len, int *ierr);


#ifdef __cplusplus
}
#endif

#endif  /* __MOD_CORE_H */
