/** \file mod_info.h       General information functions
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

#ifndef __MOD_INFO_H
#define __MOD_INFO_H

#ifdef __cplusplus
extern "C" {
#endif

/** Get the current date and time */
char *get_current_time(void);

/** Print wall and CPU time since this routine was last called */
void time_mark(void);

/** Write the Modeller header (build and copyright info) to the log. */
void write_header(void);

/** Return the short Modeller version string */
char *get_mod_short_version(void);

/** Return the long Modeller version string */
char *get_mod_long_version(void);

/** Called prior to every TOP command */
void top_pre(void);

/** Called after every TOP command */
void top_post(void);

#ifdef __cplusplus
}
#endif
#endif  /* __MOD_INFO_H */
