/** \file mod_log.h        Logging functions.
 *
 *             Part of MODELLER, Copyright(c) 1989-2007 Andrej Sali
 */

#ifndef __MOD_LOG_H
#define __MOD_LOG_H

#include <stdarg.h>
#include "mod_types.h"
#include "error_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/** Prototype for callback functions accepted by set_log_function() */
typedef int (*cb_log)(void *logdata, const char *text);

/** Write text directly to the log (no additional newline is appended) */
void wrtlog(const char *str);

/** Write an 'output' message to the log */
void modlogout(const char *format, ...);

/** Write an optional 'note' message to the log */
void modlognote(const char *format, ...);

/** Write an error message to the log (and set the error indicator) */
void modlogerror(const char *routine, int type, const char *format, ...);

/** Write a warning message to the log */
void modlogwarning(const char *routine, const char *format, ...);

/** Get the current log level */
int modget_log(int level);

/** Set the current log level */
void modset_log(int level, int value);

/** Install a callback function to handle all log output */
void modset_log_function(cb_log logfunc, cb_free freefunc, void *logdata);

#ifdef __cplusplus
}
#endif
#endif  /* __MOD_LOG_H */
