%{
#ifdef SWIGPYTHON
/* Generic Modeller error */
static PyObject *moderror;
#endif

/* Raise a Python or Perl exception if Modeller returned an error */
static int check_for_error(void)
{
  char *err;
  static const char *interr = "INTERNAL error: Error code returned, but no "
                              "error information set";
  if ((err = get_mod_error())) {
#ifdef SWIGPYTHON
    int err_type = get_mod_error_type();
    switch(err_type) {
    case ME_ZERODIV:
      PyErr_SetString(PyExc_ZeroDivisionError, err); break;
    case ME_IO:
      PyErr_SetString(PyExc_IOError, err); break;
    case ME_MEMORY:
      PyErr_SetString(PyExc_MemoryError, err); break;
    case ME_EOF:
      PyErr_SetString(PyExc_EOFError, err); break;
    case ME_TYPE:
      PyErr_SetString(PyExc_TypeError, err); break;
    case ME_NOTIMP:
      PyErr_SetString(PyExc_NotImplementedError, err); break;
    case ME_INDEX:
      PyErr_SetString(PyExc_IndexError, err); break;
    case ME_VALUE:
      PyErr_SetString(PyExc_ValueError, err); break;
    default:
      PyErr_SetString(moderror, err);
    }
#endif
#ifdef SWIGPERL
    croak(err);
#endif
    free(err);
    clear_mod_error();
    return 1;
#ifdef SWIGPYTHON
  /* Propagate a Python exception already raised (e.g. by a callback) */
  } else if (PyErr_Occurred()) {
    return 1;
#endif
  /* An error code was returned, but no error is set - this is also an error! */
  } else {
#ifdef SWIGPYTHON
    PyErr_SetString(moderror, interr);
#endif
#ifdef SWIGPERL
    croak(interr);
#endif
    return 1;
  }
}
%}
