/* Conversions between Python strings and C dstr objects */

%typemap(in) dstr * (char *temp) {
  $1 = NULL;
  if (PyString_Check($input)) {
    temp = PyString_AsString($input);
  } else {
    PyErr_Format(PyExc_TypeError, "Expected a string for argument number %d",
                 $argnum);
    SWIG_fail;
  }
}

%typemap(memberin) dstr * {
  dstr_assign($1, temp2);
}

%typemap(out) dstr * {
  $result = PyString_FromString($1->text);
}
