# Step 1: sequence search
#
# Search for sequences related to 1fdx.chn in the whole representative
# list of PDB chains and align them automatically with the target sequence.
# This will only work if PDB is installed locally and atom_files_directory
# set properly.

from modeller import *
from modeller.scripts import sequence_srch

log.verbose()
env = environ()

env.io.atom_files_directory = ['../atom_files']

try:
    sequence_srch(env, sequence='1fdx_my', segfile='1fdx.chn',
                  chains_list='test.cod', signif_cutoff=(8, 3),
                  search_randomizations=10)
except IOError:
    print
    print "The chains databases are probably not installed on your system."
    print "If desired, you can download these from the Modeller website"
    print "(Data file downloads page). However, consider using profile.build()"
    print "instead; see the basic modeling tutorial at the website."
