# Homology modeling by the automodel class
from modeller import *
from modeller.automodel import *    # Load the automodel class

log.verbose()
env = environ()

# directories for input atom files
env.io.atom_files_directory = './atom_files'

a = loopmodel(env,							
             	   alnfile  = 'valid.aln',		     			# alignment filename
             	   knowns   = ('2BBS', '2BBO', '1XMJ', '2BBT', '1XMI', 
				'1XFA', '1XF9', '1Q3H'),		        # codes of the templates
             	   sequence = 'NBD1')              			        # code of the target
a.starting_model= 1                # index of the first model 
a.ending_model  = 1                # index of the last model
                                   # (determines how many models to calculate)
a.md_level = None                  # Refinement level of model

a.loop.starting_model = 1          		 # First loop model
a.loop.ending_model   = 1          		 # Last loop model
a.loop.md_level       = refine.very_fast         # Loop model  refinement level

a.make()                           		 # do homology modeling
