#!/usr/bin/perl
#
# Author: Azat Badretdinov
# Accelrys
#

# find examples -name \*.log perl get_time.pl {} \; > benchmarks

$lfile = shift @ARGV;

@last_lines = `tail -3 $lfile`;

$start_time = &get_time(grep(/Starting time/, @last_lines));
$end_time   = &get_time(grep(/Closing time/, @last_lines));

printf "%.3f\t%s\n",  $end_time - $start_time, $lfile;

sub get_time
{
    local($_)=shift;
    local($junk);
    /:/ && ($_=$');
    local($date, $time)=split;
    local($y, $m, $d)=split(m#/#, $date);
    local($h, $mi, $s)=split(/:/, $time);
    
    return &emitlacol2($y, $m, $d-1, $h, $mi, $s);
}

sub emitlacol2
{
    local($year, $mon, $mday, $hour, $min,  $sec)=@_;
# year - A.D.
# mon - 1..
# mday, else - 0..
    
    local($appr_time)=0;
    local($l_year,$l_mon);
    foreach($l_year=1970; $l_year<$year; $l_year++)
      {
      $appr_time+= (&leap_year($l_year) ? 366 : 365)*24*3600;
      }
    foreach($l_mon=1; $l_mon<$mon; $l_mon++)
      {
      $appr_time+= &days_in_mon($l_mon, $year) *24*3600;
      }
   $appr_time+=$mday*24*3600+$hour*3600+$min*60+$sec;
   $appr_time;
}

sub leap_year
{
    local($y)=shift;
    !($y%4) && ($y%100 || !($y%400));
}

sub days_in_mon
{
    local($l_mon, $year)=@_;
    
#    @days_in_mon=
    (0, 31, (28+&leap_year($year)), 31, 30, 31, 30, 31, 31, 30, 31, 30, 31)[$l_mon];
}

1;
