#!/usr/bin/perl

# sort_cod
#
# Produces a new .cod file sorted according to the .seq file
#
# usage: sort_cod.pl filename.seq old.cod > new.cod
#
# e.g. ./sort_cod.pl ../modlib/CHAINS_all.seq ../modlib/CHAINS_3.0_30_XN.cod > CHAINS_3.0_30_XN.cod

# assign command line arguments
$seqfile = $ARGV[0];
$oldcod = $ARGV[1];

# read codes from old .cod file
open(OLDCOD,$oldcod) || die "couldn't open $oldcod";
while ( <OLDCOD> ) {
	chop;
	$flag{$_} = 1;
}
close(OLDCOD);

# print those codes from the .seqfile which are in the .cod file
open(SEQFILE,$seqfile);
while ( <SEQFILE> ) {
	chop;
	if ( /^>P1;/ ) {
		s/.*;//;
		if ( $flag{$_} == 1 ) {print "$_\n"};
	}
}
close(SEQFILE);
