import _modeller
import modutil
from modutil import set_topvars, get_topvars
from modeller.error import ModellerError

class top:
  def __init__(self, defs=None):
    self.defs = defs
  def set_tops(self, logname, vars, allowed):
    if 'stop_on_error' in allowed:
      vars['stop_on_error'] = 2
    return modutil.set_tops(logname, vars, self.defs, allowed)
  def error_check(self):
    if get_topvars(['error_status']) > 0:
      set_topvars({'error_status':0})
      raise ModellerError
  def get_argument(self, key, vars):
    if key in vars:
      return vars[key]
    elif self.defs and key in dir(self.defs):
      return eval("self.defs."+key)

  def delete_alignment(self, logname, aln, **vars):
    self.set_tops(logname, vars, ())
    _modeller.delete_alignment(aln)

  def read_alignment2(self, logname, aln2, io, **vars):
    self.set_tops(logname, vars, ())
    _modeller.read_alignment2(aln2, io)

  def read_model2(self, logname, mdl2, aln, io, **vars):
    self.set_tops(logname, vars, ())
    _modeller.read_model2(mdl2, aln, io)

  def write_model2(self, logname, mdl2, **vars):
    self.set_tops(logname, vars, ())
    _modeller.write_model2(mdl2)

  def read_alignment(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ('file', 'align_codes', 'atom_files', 'alignment_format', 'remove_gaps', 'add_sequence', 'stop_on_error', 'close_file', 'rewind_file'))
    _modeller.read_alignment(aln, io)
    self.error_check()
    return get_topvars(['end_of_file'])

  def check_alignment(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ())
    _modeller.check_alignment(aln, io)

  def compare_alignments(self, logname, aln, aln2, **vars):
    self.set_tops(logname, vars, ())
    _modeller.compare_alignments(aln, aln2)

  def sequence_to_ali(self, logname, aln, mdl, **vars):
    self.set_tops(logname, vars, ('add_sequence', 'align_codes', 'atom_files'))
    _modeller.sequence_to_ali(aln, mdl)
    self.error_check()

  def write_alignment(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory', 'alignment_format', 'align_block', 'align_alignment', 'alignment_features'))
    _modeller.write_alignment(aln)
    self.error_check()

  def edit_alignment(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ('edit_align_codes', 'base_align_codes', 'min_base_entries', 'overhang'))
    _modeller.edit_alignment(aln, io)
    self.error_check()

  def describe(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ())
    _modeller.describe(aln, io)

  def id_table(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('matrix_file', 'output_directory'))
    _modeller.id_table(aln)
    self.error_check()

  def sequence_comparison(self, logname, aln, mdl, **vars):
    self.set_tops(logname, vars, ('rr_file', 'matrix_file', 'variability_file', 'output_directory', 'max_gaps_match'))
    _modeller.sequence_comparison(aln, mdl)
    self.error_check()

  def align(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('rr_file', 'gap_penalties_1d', 'align_block', 'stop_on_error', 'off_diagonal', 'matrix_offset', 'overhang', 'max_gap_length', 'local_alignment', 'align_what', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file', 'weigh_sequences', 'smooth_prof_weight'))
    _modeller.align(aln)
    self.error_check()

  def align2d(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ('rr_file', 'gap_penalties_1d', 'gap_penalties_2d', 'align_block', 'max_gap_length', 'stop_on_error', 'off_diagonal', 'matrix_offset', 'overhang', 'local_alignment', 'align_what', 'subopt_offset', 'fit', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file', 'weigh_sequences', 'smooth_prof_weight', 'read_profile', 'input_profile_file', 'write_profile', 'output_profile_file'))
    _modeller.align2d(aln, io)
    self.error_check()

  def malign(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('rr_file', 'gap_penalties_1d', 'off_diagonal', 'align_block', 'matrix_offset', 'overhang', 'local_alignment', 'stop_on_error'))
    _modeller.malign(aln)
    self.error_check()

  def align_consensus(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('gap_penalties_1d', 'align_block', 'stop_on_error', 'max_gap_length', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file'))
    _modeller.align_consensus(aln)
    self.error_check()

  def compare(self, logname, aln, edat, io, **vars):
    self.set_tops(logname, vars, ('output', 'matrix_file', 'compare_mode', 'rms_cutoffs', 'fit_atoms', 'distance_atoms', 'fit', 'asgl_output', 'refine_local'))
    _modeller.compare(aln, edat, io)
    self.error_check()

  def align3d(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ('gap_penalties_3d', 'fit_atoms', 'fit', 'stop_on_error', 'output', 'align3d_trf', 'align3d_repeat', 'off_diagonal', 'matrix_offset', 'overhang', 'local_alignment'))
    _modeller.align3d(aln, io)
    self.error_check()

  def malign3d(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ('gap_penalties_3d', 'off_diagonal', 'matrix_offset', 'overhang', 'local_alignment', 'fit_atoms', 'fit', 'output', 'write_fit', 'edit_file_ext', 'current_directory', 'write_whole_pdb', 'stop_on_error'))
    _modeller.malign3d(aln, io)
    self.error_check()

  def salign(self, logname, aln, io, **vars):
    self.set_tops(logname, vars, ('align3d_trf', 'align_block', 'alignment_type', 'align_what', 'auto_overhang', 'comparison_type', 'current_directory', 'dendrogram_file', 'ext_tree', 'feature_weights', 'fit_atoms', 'fit_on_first', 'fit_pdbnam', 'fit', 'fix_offsets', 'gap_function', 'gap_gap_score', 'gap_penalties_1d', 'gap_penalties_2d', 'gap_penalties_3d', 'gap_residue_score', 'improve_alignment', 'input_weights_file', 'local_alignment', 'matrix_comparison', 'matrix_offset', 'max_gap_length', 'normalize_pp_scores', 'no_ter', 'n_subopt', 'off_diagonal', 'output_weights_file', 'output', 'overhang', 'overhang_auto_limit', 'overhang_factor', 'rms_cutoffs', 'rr_file', 'similarity_flag', 'smooth_prof_weight', 'stop_on_error', 'subopt_offset', 'substitution', 'weights_type', 'write_fit', 'write_weights', 'write_whole_pdb'))
    _modeller.salign(aln, io)
    self.error_check()

  def aln_to_prof(self, logname, aln, prf, **vars):
    self.set_tops(logname, vars, ('clean_sequences'))
    _modeller.aln_to_prof(aln, prf)
    self.error_check()

  def expand_alignment(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('root_name', 'file_id', 'expand_control', 'file_ext'))
    _modeller.expand_alignment(aln)
    self.error_check()

  def segment_matching(self, logname, aln, **vars):
    self.set_tops(logname, vars, ('rr_file', 'align_block', 'segment_report', 'segment_cutoff', 'segment_shifts', 'segment_growth_n', 'segment_growth_c', 'min_loop_length', 'file', 'output_directory', 'root_name', 'file_id', 'file_ext'))
    _modeller.segment_matching(aln)
    self.error_check()

  def read_density(self, logname, den, **vars):
    self.set_tops(logname, vars, ('file', 'em_density_format', 'em_map_size'))
    _modeller.read_density(den)
    self.error_check()

  def em_grid_search(self, logname, den, **vars):
    self.set_tops(logname, vars, ('em_density_format', 'num_structures', 'em_pdb_name', 'start_type', 'translate_type', 'density_type', 'number_of_steps', 'voxel_size', 'resolution', 'angular_step_size', 'temperature', 'best_docked_models', 'em_fit_output_file'))
    _modeller.em_grid_search(den)
    self.error_check()

  def make_schedule(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('library_schedule', 'schedule_scale'))
    _modeller.make_schedule(mdl)
    self.error_check()

  def read_schedule(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'schedule_scale'))
    _modeller.read_schedule(mdl)
    self.error_check()

  def write_schedule(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory'))
    _modeller.write_schedule(mdl)
    self.error_check()

  def energy(self, logname, mdl, edat, **vars):
    self.set_tops(logname, vars, ('viol_report_cut', 'viol_report_cut2', 'output', 'normalize_profile', 'smoothing_window', 'schedule_scale', 'file', 'asgl_output', 'residue_span_range'))
    _modeller.energy(mdl, edat)
    self.error_check()
    return get_topvars(['molpdf'])

  def optimize(self, logname, mdl, edat, **vars):
    self.set_tops(logname, vars, ('optimization_method', 'residue_span_range', 'trace_output', 'max_iterations', 'output', 'min_atom_shift', 'md_time_step', 'init_velocities', 'temperature', 'equilibrate', 'md_return', 'cap_atom_shift', 'stop_on_error'))
    _modeller.optimize(mdl, edat)
    self.error_check()
    return get_topvars(['molpdf'])

  def switch_trace(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory'))
    _modeller.switch_trace(mdl)
    self.error_check()

  def debug_function(self, logname, mdl, edat, **vars):
    self.set_tops(logname, vars, ('debug_function_cutoff', 'detailed_debugging'))
    _modeller.debug_function(mdl, edat)
    self.error_check()

  def assess_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.assess_model(mdl)

  def assess_ga341(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.assess_ga341(mdl)
    return get_topvars(['molpdf'])

  def dendrogram(self, logname, **vars):
    self.set_tops(logname, vars, ('cluster_cut', 'matrix_file'))
    _modeller.dendrogram()
    self.error_check()

  def principal_components(self, logname, **vars):
    self.set_tops(logname, vars, ('matrix_file', 'file'))
    _modeller.principal_components()
    self.error_check()

  def system(self, logname, **vars):
    self.set_tops(logname, vars, ('command'))
    _modeller.top_system()
    self.error_check()

  def delete_file(self, logname, **vars):
    self.set_tops(logname, vars, ('file'))
    _modeller.delete_file()
    self.error_check()

  def inquire(self, logname, **vars):
    self.set_tops(logname, vars, ('file'))
    _modeller.inquire()
    self.error_check()
    return get_topvars(['file_exists'])

  def read_atom_classes(self, logname, gprsr, **vars):
    self.set_tops(logname, vars, ('atom_classes_file'))
    _modeller.read_atom_classes(gprsr)
    self.error_check()

  def read_group_restraints(self, logname, gprsr, **vars):
    self.set_tops(logname, vars, ('file'))
    _modeller.read_group_restraints(gprsr)
    self.error_check()

  def time_mark(self, logname, **vars):
    self.set_tops(logname, vars, ())
    _modeller.time_mark()

  def read_model(self, logname, mdl, aln, io, **vars):
    self.set_tops(logname, vars, ('file', 'model_segment', 'model_format'))
    _modeller.read_model(mdl, aln, io)
    self.error_check()

  def write_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory', 'model_format', 'write_all_atoms', 'no_ter'))
    _modeller.write_model(mdl)
    self.error_check()

  def generate_topology(self, logname, mdl, aln, io, **vars):
    self.set_tops(logname, vars, ('add_segment', 'patch_default', 'sequence'))
    _modeller.generate_topology(mdl, aln, io)
    self.error_check()

  def patch(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('residue_ids', 'residue_type'))
    _modeller.patch(mdl)
    self.error_check()

  def patch_ss_templates(self, logname, mdl, aln, io, **vars):
    self.set_tops(logname, vars, ())
    _modeller.patch_ss_templates(mdl, aln, io)
    return get_topvars(['distance_atoms'])

  def patch_ss_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.patch_ss_model(mdl)

  def mutate_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('residue_type'))
    _modeller.mutate_model(mdl)
    self.error_check()

  def build_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('initialize_xyz', 'build_method'))
    _modeller.build_model(mdl)
    self.error_check()

  def unbuild_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.unbuild_model(mdl)

  def transfer_xyz(self, logname, mdl, aln, io, **vars):
    self.set_tops(logname, vars, ('cluster_cut', 'cluster_method'))
    _modeller.transfer_xyz(mdl, aln, io)
    self.error_check()

  def transfer_res_numb(self, logname, mdl, mdl2, aln, **vars):
    self.set_tops(logname, vars, ())
    _modeller.transfer_res_numb(mdl, mdl2, aln)

  def rename_segments(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('segment_ids', 'renumber_residues'))
    _modeller.rename_segments(mdl)
    self.error_check()

  def pick_atoms(self, logname, mdl, aln, **vars):
    self.set_tops(logname, vars, ('pick_atoms_set', 'selection_search', 'res_types', 'atom_types', 'selection_from', 'selection_mode', 'selection_status', 'selection_segment', 'gap_extension', 'minmax_loop_length', 'sphere_center', 'sphere_radius', 'selection_slab'))
    _modeller.pick_atoms(mdl, aln)
    self.error_check()

  def pick_hot_atoms(self, logname, mdl, edat, **vars):
    self.set_tops(logname, vars, ('viol_report_cut', 'pick_hot_cutoff', 'selection_mode', 'extend_hot_spot', 'residue_span_range'))
    _modeller.pick_hot_atoms(mdl, edat)
    self.error_check()

  def randomize_xyz(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('deviation'))
    _modeller.randomize_xyz(mdl)
    self.error_check()

  def iupac_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.iupac_model(mdl)

  def reorder_atoms(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.reorder_atoms(mdl)

  def rotate_dihedrals(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('dihedrals', 'change', 'deviation'))
    _modeller.rotate_dihedrals(mdl)
    self.error_check()

  def orient_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.orient_model(mdl)

  def rotate_model(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('translation', 'rotation_matrix', 'rotation_angle', 'rotation_axis'))
    _modeller.rotate_model(mdl)
    self.error_check()

  def write_data(self, logname, mdl, edat, **vars):
    self.set_tops(logname, vars, ('file', 'accessibility_type', 'surftyp', 'psa_integration_step', 'probe_radius', 'neighbor_cutoff', 'output'))
    _modeller.write_data(mdl, edat)
    self.error_check()

  def write_pdb_xref(self, logname, mdl, aln, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory', 'model_segment'))
    _modeller.write_pdb_xref(mdl, aln)
    self.error_check()

  def make_region(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('atom_accessibility', 'region_size'))
    _modeller.make_region(mdl)
    self.error_check()

  def color_aln_model(self, logname, mdl, aln, **vars):
    self.set_tops(logname, vars, ())
    _modeller.color_aln_model(mdl, aln)

  def superpose(self, logname, mdl, mdl2, aln, **vars):
    self.set_tops(logname, vars, ('fit', 'superpose_refine', 'rms_cutoffs', 'reference_atom', 'reference_distance', 'refine_local', 'swap_atoms_in_res'))
    _modeller.superpose(mdl, mdl2, aln)
    self.error_check()

  def make_chains(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'structure_types', 'minimal_resolution', 'minimal_chain_length', 'max_nonstdres', 'chop_nonstd_terminii', 'minimal_stdres', 'alignment_format'))
    _modeller.make_chains(mdl)
    self.error_check()

  def read_profile(self, logname, prf, **vars):
    self.set_tops(logname, vars, ('file', 'profile_format'))
    _modeller.read_profile(prf)
    self.error_check()

  def write_profile(self, logname, prf, **vars):
    self.set_tops(logname, vars, ('file', 'gap_penalties_1d', 'matrix_offset', 'profile_format', 'rr_file'))
    _modeller.write_profile(prf)
    self.error_check()

  def prof_to_aln(self, logname, prf, aln, **vars):
    self.set_tops(logname, vars, ('append_aln'))
    _modeller.prof_to_aln(prf, aln)
    self.error_check()

  def profile_profile_scan(self, logname, prf, **vars):
    self.set_tops(logname, vars, ('profile_list_file', 'profile_format', 'rr_file', 'matrix_offset', 'gap_penalties_1d', 'max_aln_evalue', 'aln_base_filename', 'score_statistics', 'output_scores', 'output_score_file', 'pssm_weights_type', 'write_summary', 'summary_file', 'output_alignments'))
    _modeller.profile_profile_scan(prf)
    self.error_check()

  def build_profile(self, logname, prf, sdb, **vars):
    self.set_tops(logname, vars, ('rr_file', 'gap_penalties_1d', 'matrix_offset', 'stop_on_error', 'n_prof_iterations', 'check_profile', 'output_scores', 'output_score_file', 'max_aln_evalue', 'gaps_in_target'))
    _modeller.build_profile(prf, sdb)
    self.error_check()

  def make_restraints(self, logname, mdl, edat, aln, io, **vars):
    self.set_tops(logname, vars, ('restraint_type', 'dih_lib_only', 'mnch_lib', 'intersegment', 'add_restraints', 'residue_grouping', 'maximal_distance', 'residue_span_range', 'residue_span_sign', 'restraint_sel_atoms', 'accessibility_type', 'distance_rsr_model', 'restraint_group', 'restraint_stdev', 'restraint_stdev2', 'restraint_parameters', 'basis_pdf_weight', 'basis_relative_weight', 'residue_ids', 'spline_on_site', 'spline_dx', 'spline_min_points', 'spline_range', 'sheet_h_bonds'))
    _modeller.make_restraints(mdl, edat, aln, io)
    self.error_check()

  def define_symmetry(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('symmetry_weight', 'add_symmetry'))
    _modeller.define_symmetry(mdl)
    self.error_check()

  def pick_restraints(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('residue_span_range', 'restraints_filter', 'restraint_sel_atoms', 'add_restraints'))
    _modeller.pick_restraints(mdl)
    self.error_check()

  def condense_restraints(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.condense_restraints(mdl)

  def add_restraint(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('atom_ids', 'restraint_parameters'))
    _modeller.add_restraint(mdl)
    self.error_check()

  def delete_restraint(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('atom_ids'))
    _modeller.delete_restraint(mdl)
    self.error_check()

  def reindex_restraints(self, logname, mdl, mdl2, **vars):
    self.set_tops(logname, vars, ())
    _modeller.reindex_restraints(mdl, mdl2)

  def spline_restraints(self, logname, mdl, edat, **vars):
    self.set_tops(logname, vars, ('spline_dx', 'spline_min_points', 'spline_range', 'spline_select', 'output', 'residue_span_range'))
    _modeller.spline_restraints(mdl, edat)
    self.error_check()

  def read_restraints(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'add_restraints'))
    _modeller.read_restraints(mdl)
    self.error_check()

  def write_restraints(self, logname, mdl, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory', 'restraints_format'))
    _modeller.write_restraints(mdl)
    self.error_check()

  def read_sequence_db(self, logname, sdb, **vars):
    self.set_tops(logname, vars, ('chains_list', 'seq_database_file', 'seq_database_format', 'clean_sequences', 'minmax_db_seq_len'))
    _modeller.read_sequence_db(sdb)
    self.error_check()

  def write_sequence_db(self, logname, sdb, **vars):
    self.set_tops(logname, vars, ('chains_list', 'seq_database_file', 'seq_database_format'))
    _modeller.write_sequence_db(sdb)
    self.error_check()

  def sequence_search(self, logname, sdb, aln, io, **vars):
    self.set_tops(logname, vars, ('rr_file', 'gap_penalties_1d', 'off_diagonal', 'matrix_offset', 'overhang', 'local_alignment', 'search_group_list', 'alignment_features', 'search_top_list', 'output', 'stop_on_error', 'search_sort', 'search_randomizations', 'fast_search', 'fast_search_cutoff', 'data_file', 'signif_cutoff'))
    _modeller.sequence_search(sdb, aln, io)
    self.error_check()

  def seqfilter(self, logname, sdb, **vars):
    self.set_tops(logname, vars, ('rr_file', 'gap_penalties_1d', 'matrix_offset', 'stop_on_error', 'output_grp_file', 'output_cod_file', 'seqid_cut', 'max_diff_res'))
    _modeller.seqfilter(sdb)
    self.error_check()

  def read_parameters(self, logname, gprsr, **vars):
    self.set_tops(logname, vars, ())
    _modeller.read_parameters(gprsr)

  def read_restyp_lib(self, logname, **vars):
    self.set_tops(logname, vars, ('restyp_lib_file'))
    _modeller.read_restyp_lib()
    self.error_check()

  def read_topology(self, logname, tpl, **vars):
    self.set_tops(logname, vars, ('file', 'add_topology'))
    _modeller.read_topology(tpl)
    self.error_check()

  def new_read_parameters(self, logname, **vars):
    self.set_tops(logname, vars, ('file'))
    _modeller.new_read_parameters()
    self.error_check()

  def make_topology_model(self, logname, tpl, **vars):
    self.set_tops(logname, vars, ())
    _modeller.make_topology_model(tpl)

  def write_topology_model(self, logname, tpl, **vars):
    self.set_tops(logname, vars, ('file', 'output_directory'))
    _modeller.write_topology_model(tpl)
    self.error_check()

