# Addition of restraints to the default ones

from modeller.automodel import *    # Load the automodel class

log.verbose()
env = environ()

# directories for input atom files
env.io.atom_files_directory = './:../atom_files'

class mymodel(automodel):
    def special_restraints(self, aln):
        rsr = self.restraints
#       Add some restraints from a file:
#       rsr.append(file='my_rsrs1.rsr')
#       Restrain the specified CA-CA distance to 10 angstroms (st. dev.=0.1)
#       Use a harmonic potential and X-Y distance group.
        rsr.add(atom_ids=('CA:35', 'CA:40'),
                restraint_parameters=(3, 1, 1, 27, 2, 2, 0, 10.0, 0.1))

a = mymodel(env,
            alnfile  = 'alignment.ali',     # alignment filename
            knowns   = '5fd1',              # codes of the templates
            sequence = '1fdx')              # code of the target
a.starting_model= 1                 # index of the first model 
a.ending_model  = 1                 # index of the last model
                                    # (determines how many models to calculate)
a.make()                            # do homology modelling
