# Homology modelling by the automodel class
#
# Demonstrates how to refine only a part of the model.
#
# You may want to use the more exhaustive "loop" modeling routines instead.
#

from modeller.automodel import *    # Load the automodel class

log.verbose()

# Override the 'select_atoms' routine in the 'automodel' class
class mymodel(automodel):
    def select_atoms(self):
        self.pick_atoms(selection_segment=('1:', '2:'),
                        selection_search='segment', pick_atoms_set=1,
                        res_types='all', atom_types='all',
                        selection_from='all', selection_status='initialize')


env = environ()
# directories for input atom files
env.io.atom_files_directory = './:../atom_files'
# selected atoms do not feel the neighborhood
env.edat.nonbonded_sel_atoms = 2

a = mymodel(env,
            alnfile  = 'alignment.ali',     # alignment filename
            knowns   = '5fd1',              # codes of the templates
            sequence = '1fdx')              # code of the target

a.starting_model= 3                # index of the first model 
a.ending_model  = 3                # index of the last model
                                   # (determines how many models to calculate)
a.make()                           # do homology modelling
