# Example for: model.debug_function()

# This will use the MODELLER automodel class to construct homology
# restraints for 1fas. It will then use model.debug_function() to test
# the source code for the function and derivatives calculation
# by comparing analytical and numerical first derivatives (note that
# automodel is a derived class of model, so all 'model' methods will work
# on 'automodel'). Some discrepancies may be reported but ignore them here.

from modeller.automodel import *    # Load the automodel class

log.verbose()
env = environ()

a = automodel(env, alnfile = 'debug_function.ali',
              knowns  = ('2ctx', '1nbt'), sequence = '1fas')
a.spline_on_site = False
a.make(exit_stage=1)

# To assign 0 weights to restraints whose numerical derivatives
# code does not work (i.e., splines for angles and dihedrals):
a.schedule.read(file='debug_function.sched')
a.energy(output='SHORT')
a.debug_function(debug_function_cutoff=(15.00, 0.10, 0.1),
                 detailed_debugging=True)
