# Example for: model.pick_hot_atoms()

# This will pick atoms violated by some restraints (bond length restraints here),
# select restraints operating on violated atoms, and calculate the energy for 
# the selected restraints only (note that a list of violated restraints
# can be obtained by the ENERGY command alone, without preceding it with
# PICK_HOT_ATOMS).

env = environ()
env.edat.dynamic_sphere = False
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

# Read the sequence, calculate its topology and coordinates:
code = '1fas'
mdl = model(env, file=code)
aln = alignment(env)
aln.append_model(mdl, atom_files=code, align_codes=code)
aln.append_model(mdl, atom_files=code+'.ini', align_codes=code+'-ini')
mdl.generate_topology(aln, sequence=code+'-ini')
mdl.transfer_xyz(aln)
# Just to get some violations:
mdl.randomize_xyz(deviation=0.03)
# Create the bond length restraints and ignore the hard sphere overlap:
mdl.restraints.make(aln, restraint_type='bond', spline_on_site=False)
# Pick hot atoms and the corresponding violated and neighbouring restraints:
mdl.pick_hot_atoms(pick_hot_cutoff=4.0)
mdl.restraints.pick(add_restraints=False)
# Calculate the energy of the selected restraints and write them out in detail:
mdl.energy(output='VERY_LONG')
