# Example for: model.res_num_from()

# This will transfer residue numbers and chain ids from model2 to model.

log.level(output=1, notes=1, warnings=1, errors=1, memory=0)
env = environ()

# Read an alignment for the transfer
aln = alignment(env, file='toxin.ali', align_codes=('2ctx', '1fas'))
# Read the template and target models:
mdl2 = model(env, file='2ctx')
mdl  = model(env, file='1fas')
# Transfer the residue and chain ids and write out the new MODEL:
mdl.res_num_from(mdl2, aln)
mdl.write(file='1fas.ini')
