"""Methods to perturb the initial model. Usually called by setting
   automodel.rand_method."""

def xyz(mdl):
    """Randomize all coordinates"""
    mdl.randomize_xyz(deviation=mdl.deviation)

def dihedrals(mdl):
    """Randomize dihedrals"""
    aln = alignment(mdl.env, file=mdl.alnfile,
                    align_codes=mdl.knowns+[mdl.sequence])
    # Just in case, generate topology again (ROTATE needs bonds)
    # (could replace with GENERATE_TOPOLOGY if no special patches)
    mdl.create_topology(aln)

    # Optimize all dihedral angles:
    mdl.rotate_dihedrals(change='RANDOMIZE', deviation=mdl.deviation,
                         dihedrals=('phi', 'psi', 'omega', 'chi1', 'chi2',
                                    'chi3', 'chi4'))
