import _modeller
from modeller.util.modobject import modobject

class energy_data(modobject):
    """Defines the type of energy function to use"""

    lennard_jones_switch = [6.5, 7.5]
    coulomb_switch = [6.5, 7.5]
    contact_shell = 4.0
    relative_dielectric = 1.0
    radii_factor = 0.82
    update_dynamic = 0.39
    nonbonded_sel_atoms = 1
    covalent_cys = False
    excl_local = [True, True, True, True]
    nlogn_use = 15
    sphere_stdv = 0.05
    dynamic_pairs = False
    dynamic_sphere = True
    dynamic_coulomb = False
    dynamic_lennard = False
    dynamic_modeller = False
    dynamic_access = False
    dynamic_gbsa = False
    density = None

    def __init__(self, copy=None, **kwargs):
        self.add_members(('_energy_data__modpt',))
        self.__modpt = _modeller.new_energy_data()
        if copy:
            for member in copy.__dict__:
                if 'energy_data' not in member:
                    self.__dict__[member] = copy.__dict__[member]
        for key in kwargs:
            if key in dir(energy_data):
                exec("self."+key+"="+str(kwargs[key]))
            else:
                raise KeyError, str(key)

    def __del__(self):
        _modeller.free_energy_data(self.modpt)

    def __get_modpt(self):
        modpt = self.__modpt
        _modeller.set_energy_data(modpt,
                                  self.contact_shell, self.relative_dielectric,
                                  self.radii_factor, self.sphere_stdv,
                                  self.update_dynamic, self.nonbonded_sel_atoms,
                                  self.nlogn_use, self.covalent_cys,
                                  self.dynamic_pairs, self.dynamic_sphere,
                                  self.dynamic_coulomb, self.dynamic_lennard,
                                  self.dynamic_modeller, self.dynamic_access,
                                  self.dynamic_gbsa, self.lennard_jones_switch,
                                  self.coulomb_switch, self.excl_local)
        if self.density:
            _modeller.set_edata_density(modpt, self.density.modpt)
        else:
            _modeller.unset_edata_density(modpt)
        return modpt

    modpt = property(__get_modpt)
