import _modeller

class logger(object):
    """A simple log class to divert Python output to the Modeller logfile"""

    def __init__(self):
        self.buffer = ""

    def __del__(self):
        """Flush anything still in the buffer, on exit"""
        self.flush()

    def flush(self):
        """Flush anything in the buffer"""
        if self.buffer != "":
            self.write("\n")

    def level(self, output=1, notes=0, warnings=0, errors=1, memory=0):
        """Set the logging level - i.e. which messages to output"""
        for (indx, val) in enumerate((output, notes, warnings, errors, memory)):
            _modeller.set_log(indx + 1, val)

    def minimal(self):
        """Only print important logging messages"""
        self.level(output=1, notes=0, warnings=0, errors=1, memory=0)

    def verbose(self):
        """Print verbose logging messages"""
        self.level(output=1, notes=1, warnings=1, errors=1, memory=1)

    def very_verbose(self):
        """Print verbose logging messages, with dynamic memory breakdown"""
        self.level(output=1, notes=1, warnings=1, errors=1, memory=2)

    def write(self, text):
#       Modeller's wrtlog always appends a newline, so only call it when we have
#       a newline-terminated string in the buffer, and then remove our own
#       newline
        self.buffer += text
        if len(self.buffer) > 0 and \
           (self.buffer[-1] == "\n" or self.buffer[-1] == "\r"):
            _modeller.wrtlog(self.buffer[:-1])
            self.buffer = ""

    def __set_output(self, val):
        _modeller.set_log(1, val)
    def __get_output(self):
        return _modeller.get_log(1)
    def __set_notes(self, val):
        _modeller.set_log(2, val)
    def __get_notes(self):
        return _modeller.get_log(2)
    def __set_warnings(self, val):
        _modeller.set_log(3, val)
    def __get_warnings(self):
        return _modeller.get_log(3)
    def __set_errors(self, val):
        _modeller.set_log(4, val)
    def __get_errors(self):
        return _modeller.get_log(4)
    def __set_memory(self, val):
        _modeller.set_log(5, val)
    def __get_memory(self):
        return _modeller.get_log(5)
    output = property(__get_output, __set_output)
    notes = property(__get_notes, __set_notes)
    warnings = property(__get_warnings, __set_warnings)
    errors = property(__get_errors, __set_errors)
    memory = property(__get_memory, __set_memory)
