from loopmodel import loopmodel
from modeller import group_restraints

class dope_loopmodel(loopmodel):
    """Loop modeling using the DOPE potential"""

    def __init__(self, env, sequence, alnfile=None, knowns=None, inimodel=None,
                 deviation=None, library_schedule=None, toplib=None,
                 parlib=None, topology_model=None, csrfile=None, inifile=None,
                 assess_methods=None, loop_assess_methods=None):
        loopmodel.__init__(self, env, sequence, alnfile, knowns, inimodel,
                           deviation, library_schedule, toplib, parlib,
                           topology_model, csrfile, inifile, assess_methods,
                           loop_assess_methods)
        self.loop.env.schedule_scale = (1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                                        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                                        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                                        1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0,
                                        1.0, 1.0, 0.6, 1.0, 1.0, 1.0, 1.0)
        edat = self.loop.env.edat
        edat.contact_shell=8.00
        edat.dynamic_sphere=False
        edat.dynamic_lennard=True
        edat.dynamic_coulomb=False
        edat.relative_dielectric=1.0
        edat.dynamic_modeller=True
        edat.dynamic_gbsa=True

    def read_potential(self):
        return group_restraints(self.env, classes='$(LIB)/atmcls-mf.lib',
                                parameters='$(LIB)/dist-mf.lib')
