from io_data import io_data
from energy_data import energy_data
from libraries import libraries
from modeller.util import top, modutil
from modeller.util.modobject import modobject

class environ(modobject):
    """Defaults for Modeller variables"""

    # default random seed
    rand_seed = -8123
    # substitution matrix offset for local alignment
    matrix_offset = 0.00
    # cutoffs for reporting relative violations
    viol_report_cut = (4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5, 4.5,
                       4.5, 4.5, 999, 999, 999, 999, 4.5, 4.5, 4.5, 4.5, 4.5,
                       4.5, 999, 6.5, 4.5, 4.5, 4.5, 4.5, 4.5, 999, 999, 999,
                       4.5, 4.5)
    # cutoffs for reporting differences between numerical and analytical
    # derivatives: absolute, relative errors, factor_for_indiv_rstrs
    debug_function_cutoff = (0.01, 0.001, 0.1)
    # minimal atomic shift for the optimization convergence test
    min_atom_shift = 0.010
    # cutoffs for RMS, DRMS, Alpha Phi Psi Omega chi1 chi2 chi3 chi4 chi5
    rms_cutoffs = (3.5, 3.5, 60., 60., 15., 60., 60., 60., 60., 60., 60.)
    # the cutoff weight of basis pdf's for their removal
    basis_relative_weight = 0.05
    # maximal distance for distance restraints
    maximal_distance = 999.
    # keep restraints?
    restraints_filter = (-999,) * 35
    optimization_method = -999
    md_time_step = 4.0
    temperature = 293.0
    md_return = 'FINAL'
    residue_span_range = (0, 99999)
    distance_rsr_model = 1
    restraint_group = 26
    restraints_format = 'MODELLER'
    input_weights_file = ''
    output_weights_file = ''
    input_profile_file = ''
    output_profile_file = ''
    file = ''
    pick_atoms_set = 1
    reference_atom = ''
    fit_atoms = 'CA'
    output = 'LONG'
    add_segment = False
    seq_database_format = 'PIR'
    id2 = 1
    root_name = 'undf'
    file_id = 'default'
    file_ext = ''
    atom_ids = ('',)
    # limit for atomic shifts in optimization
    cap_atom_shift = 0.2
    # gap creation and extension penalties for structure/structure superposition
    gap_penalties_3d = (0.0, 1.75)
    # Coordinate randomizaton amplitude in angstroms
    deviation = 0.0
    # transforming factors for standard deviations (y=a+bx) in models 1--6 or
    # standard deviation for model 7 (a)
    restraint_stdev = (0.0, 1.0)
    # interval size for splining restraints
    spline_dx = 0.5
    # range of the splines
    spline_range = 4.0
    # user restraint parameters
    restraint_parameters = (3, 1, 3, 3, 4, 2, 0, 0.0, 0.087)
    residue_ids = ''
    sheet_h_bonds = 7
    sphere_center = ('undefined', 'undefined')
    sphere_radius = 10.
    selection_slab = (-9999, 9999, 0, 0, 0)
    # gap penalties for sequence/structure alignment: helix, beta,
    # accessibility, straightness, and CA--CA distance factor, dst min,
    # dst power, t, structure_profile; best U,V=-450,0
    gap_penalties_2d = (3.5, 3.5, 3.5, 0.2, 4.0, 6.5, 2.0, 0., 0.)
    # factors for physical restraint types in scaling the schedule
    schedule_scale = (1.,) * 35
    # definition of a cluster
    cluster_cut = -1.0
    # gap creation and extension penalties for sequence/sequence alignment
    gap_penalties_1d = (-900., -50.)
    # if FAST_SEARCH is ON only sequences with database scan significance higher
    # than this value are considered for randomization significance
    fast_search_cutoff = 1.0
    viol_report_cut2 = (2.0,) * 35
    # cutoff for adding sequences to alignment, max difference from the best
    signif_cutoff = (4.0, 5.0)
    # cutoff for writing out an alignment in SEGMENT_MATCHING
    segment_cutoff = 999999
    # offsets of the ALIGN2D alignment score for "fixed" positions indicated by
    # ' 123456789' in line '_fix_pos'
    fix_offsets = (0., -1., -2., -3., -4.)
    # integration step for WRITE_DATA
    psa_integration_step = 0.1
    # accessible atoms for MAKE_REGION
    atom_accessibility = 1.0
    # probe_radius for WRITE_DATA
    probe_radius = 1.4
    # cutoff for selecting reference positions in SUPERPOSE
    reference_distance = 3.5
    # offset for residue-residue score in getting suboptimals in ALIGN/ALIGN2D
    subopt_offset = 0.0
    # for smoothing the profile aa frequency with a prior
    smooth_prof_weight = 10
    # for defining atom-atom contacts in WRITE_DATA
    neighbor_cutoff = 6.0
    # gap creation and extension penalties for SALIGN
    gap_penalties = (2., 0.5)
    # dissimilarity score for aligning gap with gap, in SALIGN
    gap_gap_score = 0.
    # dissimilarity score for aligning gap with residue, in SALIGN
    gap_residue_score = 0.
    # grid size for cavities calculation in WRITE_DATA
    grid_unit = 1.
    # minimal alignment sequence identity in BUILD_PROFILE
    min_aln_seq_id = 40.
    # Radius of cut-off for a short sphere of atoms
    rcutp = 3.0
    # Radius of cut-off for a long  sphere of atoms
    rcutl = 5.0
    # transforming standard deviation in models 3--6:
    # S' = S + [ a + b max(0, c-g) ]
    restraint_stdev2 = (0., 0., 0.)
    # Max. E-value of alignments to include in BUILD_PROFILE
    max_aln_evalue = 0.1
    # Minimum volume [A^3] of a cluster of internal cavities
    vmin = 7.5
    # Radius of cut-off to link in a cluster of internal cavities
    rlink = 1.2
    # substitution matrix scoring parameters, lambda and kappa - used by
    # build_profile
    matrix_scaling_factor = 0.0069
    # filter parameters for EM_GRID_SEARCH
    filter_values = (0., 0.)
    residue_grouping = 1
    matrix_file = 'family.mat'
    # selects the type of comparison: 1 | 2 | 3
    compare_mode = 3
    # whether to extend hot spots
    extend_hot_spot = 0
    # starting residue index for renumbering residues
    renumber_residues = []
    # type of solvent accessibility: 1--10
    accessibility_type = 8
    # maximal length of gap in protein comparisons
    max_gap_length = 999999
    # extend insertions/deletions for that many residues, in PICK_ATOMS
    gap_extension = (2, 1)
    # modulus for writing information about optimization iterations: 0 for
    # nothing
    trace_output = 0
    # the length of the output hits list
    search_top_list = 20
    # equilibrate during MD every that many steps
    equilibrate = 999999
    max_gaps_match = 1
    # the last sequence in the first block of sequences
    align_block = 0
    # number of randomizations for calculating the significance of a
    # sequence/sequence similarity
    search_randomizations = 0
    # to speed up the alignment
    off_diagonal = 100
    # un-penalized overhangs in protein comparisons
    overhang = 0
    # specification of the restraints to be splined: {\tt form  feature  group}
    spline_select = (4, 1, 9)
    # have at least as many intervals in a spline
    spline_min_points = 5
    # profiles are smoothed over 2*SW + 1 residues
    smoothing_window = 3
    # a restraint other than non-bonded pair has to have at least as many
    # selected atoms
    restraint_sel_atoms = 1
    # number of optimal and suboptimal alignments ALIGN/ALIGN2D
    n_subopt = 1
    # 1 ... 35 physical type to be presented as 2D energy profile2
    profile_2d_phys = 35
    segment_report = 1e6
    # which MNCH lib to use in MAKE_RESTRAINTS
    mnch_lib = 1
    # size of exposed region in MAKE_REGION
    region_size = 20
    # minimal/maximal length of a loop in PICK_ATOMS
    minmax_loop_length = (5, 15)
    # length cut-off for selecting chains
    minimal_chain_length = 30
    # min. number of standard residues
    minimal_stdres = 30
    # for calculating cavity volume
    number_of_steps = 1
    # minimal/maximal database sequence length
    minmax_db_seq_len = (0, 999999)
    # number of iterations in PROFILE_SEARCH
    n_prof_iterations = 3
    # minimal number residues in alignment for BUILD_PROFILE
    min_aln_len = 50
    # minimal number of templates in EDIT_ALIGNMENT
    min_base_entries = 1
    # Surface Type for accessibility calculations 1= contact; 2=surface
    surftyp = 1
    # Sequence Identity cut-off for SEQFILTER
    seqid_cut = 95
    # Length cut-off for SEQFILTER
    max_diff_res = 30
    # Cut-off for number of unaligned residues in SEQFILTER
    max_unaligned_res = 10
    # max. number of non-standard residues
    max_nonstdres = 10
    # number of structures to dock in EM_GRID_SEARCH
    num_structures = 1
    # number of best docked models to keep in EM_GRID_SEARCH
    best_docked_models = 1
    # output directory
    output_directory = ''
    # dihedral angle type selection: \Z{phi}  | \Z{psi}  | \Z{omega} | \Z{chi1}
    # | \Z{chi2} | \Z{chi3} | \Z{chi4} | \Z{chi5} | \Z{alpha}
    dihedrals = ('PHI', 'PSI', 'CHI1', 'CHI2', 'CHI3', 'CHI4')
    # residue type selection
    res_types = 'ALL'
    # atom type selection
    atom_types = 'ALL'
    # selects input atom file format: \Z{PDB} | \Z{CHARMM} | \Z{UHBD}
    model_format = 'PDB'
    # format of the alignment file: \Z{PIR} | \Z{PAP} | \Z{QUANTA} | \Z{INSIGHT}
    # | \Z{FASTA}
    alignment_format = 'PIR'
    # what alignment features to write out: \Z{ACCURACY} | \Z{HELIX} | \Z{BETA}
    # | \Z{ACCESSIBILITY} | \Z{STRAIGHTNESS}
    # | \Z{CONSERVATION} | \Z{INDICES} | \Z{ALL} | \Z{GAPS}
    alignment_features = 'INDICES CONSERVATION'
    # a method for calculation of basis pdf weights: \Z{LOCAL} | \Z{GLOBAL}
    basis_pdf_weight = 'LOCAL'
    # atom types for distance generation
    distance_atoms = ('CA', 'CA')
    # selecting what: \Z{ATOM} | \Z{RESIDUE}
    selection_mode = 'ATOM'
    # search method: \Z{SPHERE} | \Z{SEGMENT} | \Z{SPHERE_SEGMENT}
    selection_search = 'SEGMENT'
    # what to do with selected atoms: \Z{ADD} | \Z{REMOVE} | \Z{INITIALIZE}
    selection_status = 'INITIALIZE'
    # \Z{RES:CHN} ids for the first and last residues in a chain/segment;
    # or 'LOOPS'
    selection_segment = ('', '')
    # selecting from: \Z{ALL} | \Z{SELECTED}
    selection_from = 'ALL'
    # input residue-residue scoring file
    rr_file = '$(LIB)/as1.sim.mat'
    # segment to be read in
    model_segment = ('FIRST:@', 'LAST:')
    # which sequence to use for normalization when sorting the hit list:
    # \Z{SHORTER} | \Z{LONGER}
    search_sort = 'LONGER'
    # what to align in ALIGN; \Z{BLOCK} | \Z{ALIGNMENT} | \Z{LAST} | \Z{PROFILE}
    align_what = 'BLOCK'
    # what distance function to use; \Z{RMSD} | \Z{MAXIMAL_DISTANCE}
    cluster_method = 'RMSD'
    # file with 40\% groups of sequences
    search_group_list = '$(LIB)/CHAINS_3.0_40_XN.grp'
    # residue type library
    restyp_lib_file = '$(LIB)/restyp.lib'
    # for Accelrys:
    #restyp_lib_file = '$(LIB)/restyp_accelrys.lib'
    # minimize RMS by swapping atoms in these residues (1 char code:
    # 'DEFHLNQRVY')
    swap_atoms_in_res = ''
    # 'structure structureX structureN structureM structureF structureE
    #  structureU'
    structure_types = 'structure'
    # 'PIR' 'FASTA' 'BINARY'; for READ/WRITE_SEQUENCE_DB
    seq_database_format = 'PIR'
    # 'TEXT' | 'BINARY' ; for READ/WRITE_PROFILE
    profile_format = 'TEXT'
    # list of profiles for PROFILE_PROFILE_SCAN
    profile_list_file = ''
    # codes of proteins in the alignment to be edited
    edit_align_codes = 'last'
    # codes of proteins in the alignment to be used as the base
    base_align_codes = 'rest'
    # 'MAT' or 'PSSM' for comparing matrices or PSSMs when profiles are compared
    comparison_type = 'MAT'
    # 'CC', 'MAX', 'AVE', - kinds of matrix comparisons
    matrix_comparison = 'CC'
    # 'DEFAULT', 'BUILD' - seq.tree types (default = malign)
    tree_type = 'DEFAULT'
    # old and new file extensions for filename construction in MALIGN3D
    edit_file_ext = ('.pdb', '_fit.pdb')
    # 'PAIRWISE' 'TREE' 'PROGRESSIVE' for SALIGN
    alignment_type = 'PROGRESSIVE'
    # 'REGULAR' for 20 residues of 'GENERALIZED' otherwise
    residue_type2 = 'REGULAR'
    # or 'DISTANCE' -> for the kind of substitution values
    weights_type = 'SIMILAR'
    # output file for seqfilter groups
    output_grp_file = 'seqfilt.grp'
    # output file for seqfilter representative groups
    output_cod_file = 'seqfilt.cod'
    # output file for writing out individual scores in seqfilter
    output_score_file = 'default'
    # input density map file format for EM_GRID_SEARCH; \Z{MRC} | \Z{XPLOR}
    em_density_format = 'XPLOR'
    # order to dock proteins in EM_GRID_SEARCH; \Z{INPUT} | \Z{SIZE}
    dock_order = 'INPUT'
    # how to start EM_GRID_SEARCH; \Z{CENTER} | \Z{ENTIRE} | \Z{SPECIFIC}
    start_type = 'CENTER'
    # how to perform translations during EM_GRID_SEARCH; \Z{NONE} | \Z{RANDOM}
    # | \Z{EXHAUSTIVE}
    translate_type = 'NONE'
    # how to filter the density during EM_GRID_SEARCH; \Z{NONE} | \Z{THRESHOLD}
    # | \Z{THRESHOLD2} | \Z{SQUARE}
    filter_type = 'NONE'
    # output file for EM_GRID_SEARCH
    em_fit_output_file = ''
    # Function used to calculate density map cross-correlation in
    # density.grid_search();
    # \Z{SPHERE} | \Z{GAUSS} | \Z{HYBRID} | \Z{GAUSS_NORM} | \Z{TRACE} 
    density_type = 'SPHERE'
    # background probability values for a residue-residue substitution matrix
    bkgrnd_prblty_file = '$(LIB)/blosum62_bkgrnd.prob'
    # input residue-residue target frquency file
    rr_ij_file = '$(LIB)/blosum62.qij.mat'
    # basename for construction of alignment filenames used by
    # PROFILE_PROFILE_SCAN
    aln_base_filename = 'alignment'
    # ASSESS_MODEL: assessment method to use
    assess_method = ''
    # type of weighting to calculate pssm; \Z{HH0} | \Z{HH1}
    pssm_weights_type = 'HH1'
    write_pssm = False
    pssm_file = ''
    # output file for writing PPSCAN summary
    summary_file = 'ppscan.sum'
    # whether to do pairwise least-squares fitting or ALIGN2D alignment
    fit = True
    # whether to refine the superposition
    superpose_refine = False
    # whether to write out fitted coordinates to .fit files
    write_fit = False
    # whether to write output for ASGL
    asgl_output = False
    # whether to remove all-gap positions in input alignment
    remove_gaps = True
    # whether to do local as opposed to global alignment
    local_alignment = False
    # whether to transform the distances before dynamic programming
    align3d_trf = False
    # whether to do default NTER and CTER patching
    patch_default = True
    # whether to restrain inter-segment non-bonded pairs
    intersegment = True
    # do several starts to maximize number of equivalent positions
    align3d_repeat = False
    # writing out an alignment of alignments (for *)
    align_alignment = False
    # whether to initialize velocities before MD
    init_velocities = True
    # whether to write out all lines in the input PDB file
    write_whole_pdb = True
    # whether to write all atoms, even if unselected
    write_all_atoms = True
    # whether to write output .fit files to current directory
    current_directory = True
    # whether to evaluate energy and derivatives wrt each restraint
    detailed_debugging = False
    # whether to use fast sequence search or not
    fast_search = False
    # whether results go to a separate file or not
    data_file = False
    # whether to normalize energy/violations profiles or not, by the number of
    # terms per residue
    normalize_profile = False
    # whether to do N*(N-1)/2 loop for atom pairs in MAKE_RESTRAINTS
    # RESTRAINT_TYPE = 'distance'
    residue_span_sign = True
    # whether to read the whole NxM weight matrix for ALIGN*
    read_weights = False
    # whether to use only library, not homologs for dihedral angle rsrs
    dih_lib_only = False
    # whether to not write TER into PDB
    no_ter = False
    # whether to write the whole NxM weight matrix for ALIGN*
    write_weights = False
    # whether to read str profile for ALIGN2D
    read_profile = False
    # whether to write str profile for ALIGN2D
    write_profile = False
    # whether or not to weigh sequences in a profile
    weigh_sequences = False
    # whether or not to follow a tree for MALIGN3D
    follow_tree = False
    # whether or not to chop non-standard N- and/or C-terminal residue in
    # MAKE_CHAINS
    chop_nonstd_terminii  = True
    # whether or not to normalize position-position scores in SALIGN
    normalize_pp_scores = False
    # whether or not to optimize alignment in SALIGN
    improve_alignment = True
    # whether or not all structures are to be fit on the first structure, given
    # the final alignment
    fit_on_first = False
    # whether or not to add _fit to the PDB file name in output alifile by
    # SALIGN
    fit_pdbnam = True
    # whether or not to orient structure before volume calculation in WRITE_DATA
    orient = False
    # whether or not clean non-standard residues
    clean_sequences = True
    # whether or not to close the alignment file at the end of READ_ALIGNMENT
    close_file = True
    # whether or not to rewind the alignment file at the start of READ_ALIGNMENT
    rewind_file = False
    # whether or not the closure on the surface accepts diagonal cords
    accuracy_border = False
    # whether or not to switch on functional gap penalty in salign
    gap_function = False
    # whether to use the background in PSSM comparison
    substitution = False
    # whether to monitor profile degenration
    check_profile = True
    # whether to output individual scores in a build_profile scan
    output_scores = False
    # whether to include gaps in target when using build_profile
    gaps_in_target = False
    # whether to append profiles to existing alignment arrays
    append_aln = False
    # when turned on, the SALIGN command does not convert numbers into a
    # distance sense.
    similarity_flag = False
    # PROFILE_PROFILE_SCAN: if turned off, the length-normalized z-scores are
    # not computed
    score_statistics = True
    # PROFILE_PROFILE_SCAN: if turned off, no alignments will be written out.
    output_alignments = True
    # whether to refine superposition using locally similar substructures
    refine_local = True
    # whether to write summary information for PPSCAN
    write_summary = True
    # To read a pre computed tree for SALIGN
    ext_tree = False
    # File into which the SALIGN dendrogram is written out
    dendrogram_file = ''
    # feature weights for SALIGN
    feature_weights = (1., 0., 0., 0., 0., 0.)
    # Factor to multiply seq. length diff with when auto_overhang is on
    overhang_factor = 0.4
    # auto_overhang effective if seq length diff > overhang_auto_limit
    overhang_auto_limit = 60
    # Overhang values made dependent on sequence length difference
    auto_overhang = False
    # half segment length for DRMS calculation
    nsegm = 2
    # Matrix offset value for RMS feature DP in SALIGN (unoptimized 24_Jan 06)
    matrix_offset_3d = -0.1

    def __init__(self, rand_seed=None, restyp_lib_file=None, copy=None):
        self.add_members(('io', 'edat', 'libs', 'group_restraints'))
        self.group_restraints = None
        if copy:
            self.libs = copy.libs
            self.io = io_data(copy=copy.io)
            self.edat = energy_data(copy=copy.edat)
            for member in copy.__dict__:
                if 'environ' not in member and member not in self.__dict__:
                    self.__dict__[member] = copy.__dict__[member]
        else:
            if rand_seed is not None:
                self.rand_seed = rand_seed
            if restyp_lib_file is not None:
                self.restyp_lib_file = restyp_lib_file
            self.libs = libraries(self)
            self.io = io_data()
            self.edat = energy_data()

    def copy(self):
        """Returns a copy of this environment"""
        return environ(copy=self)

    def system(self, command):
        t = top.top(self)
        return t.system('environ.system', command=command)

    def dendrogram(self, **vars):
        t = top.top(self)
        return t.dendrogram('environ.dendrogram', **vars)

    def principal_components(self, matrix_file, file):
        t = top.top(self)
        return t.principal_components('environ.principal_components',
                                      matrix_file=matrix_file, file=file)
