import _modeller
import util.top as top

class parameters(object):
    """All information from a parameter file"""

    def __init__(self, libs):
        self.libs = libs
        self.env = self.libs.env
        self.__modpt = _modeller.get_libraries_parameters(libs.modpt)
        self.top = top.top(self.env)

    def clear(self):
        _modeller.clear_parameters(self.modpt)

    def append(self, libs=None, **vars):
        if libs is None:
            libs = self.env.libs
        return self.top.new_read_parameters('parameters.append',
                                            prm=self.modpt, libs=libs.modpt,
                                            **vars)

    def read(self, libs=None, **vars):
        self.clear()
        return self.append(libs, **vars)

    def __get_modpt(self):
        return self.__modpt
    def __get_in_memory(self):
        return _modeller.parameters_read(self.modpt)

    modpt = property(__get_modpt)
    in_memory = property(__get_in_memory)
