import _modeller

def set_tops(logname, dictvars, defs, arg_allowed):
  args = []
  logstring = "runcmd______> " + logname + '('
  first = True
  if not isinstance(arg_allowed, (tuple, list)):
    arg_allowed = (arg_allowed,)
  for key in arg_allowed:
    if not first:
      logstring += ', '
    first = False
    if key in dictvars:
      logstring += key + "=" + repr(dictvars[key])
      args.append(dictvars[key])
      del dictvars[key]
    else:
      try:
        defval = eval("defs."+key)
        logstring += "(def)" + key + "=" + repr(defval)
        args.append(defval)
      except AttributeError:
        require_argument(key, logname)
  for key in dictvars:
    raise SyntaxError, "Variable " + repr(key) + \
                       " is not valid for " + logname
  log_output(logstring + ')')
  return args

def log_output(logstring):
  out_control = _modeller.get_log(2)
  if out_control > 0:
    print logstring
    print

def require_argument(key, logname):
  raise SyntaxError, "A value must be given for " + repr(key) + \
                     " for " + logname

def get_topvars(toplist, vars):
  if not isinstance(toplist, (list, tuple)):
    toplist = (toplist,)
  retval = []
  for name in toplist:
    retval.append(vars[name])
  if (len(retval) == 1):
    return retval[0]
  else:
    return retval

def set_topvars(topvardict, vars, topini):
  for name in topvardict.keys():
    value = topvardict[name]
    if value is None:
      continue
    (typ, num) = topini[name]
    setfuncs = { 'S': [ str, [int, float] ],
                 'L': [ bool, [] ],
                 'R': [ float, [int] ],
                 'I': [ int, [] ] }
    (top_type, top_oktypes) = setfuncs[typ]
    if not isinstance(value, (list, tuple)):
      value = [value]
    check_top_dim(num, len(value))
    for val in value:
      val = check_top_type(name, val, top_type, top_oktypes)
    if typ == 'S':
      value = list(value)
      for indx in range(len(value)):
        value[indx] = str_macro(value[indx], vars)
    if num == 1:
      vars[name] = value[0]
    else:
      vars[name] = tuple(value)

def str_macro(value, vars):
  try:
    directory = vars['directory']
    root_name = vars['root_name']
    id1 = vars['id1']
    id2 = vars['id2']
    file_ext = vars['file_ext']
    file_id = vars['file_id']
  except KeyError:
    return value
  return _modeller.str_macro(value, directory, root_name, id1, id2, file_ext,
                             file_id)

def check_top_type(name, value, top_type, top_oktypes):
  if type(value) is not top_type:
    if type(value) in top_oktypes:
      value = top_type(value)
    else:
      raise TypeError, "Incorrect element type for variable %s" % (name.upper())
  return value

def check_top_dim(orig_dim, new_dim):
  if orig_dim != new_dim and orig_dim != 0:
    raise TypeError, ("Numbers of expected, actual arguments "
                      + "are different: %d  %d") % (orig_dim, new_dim)

def handle_seq_indx(seqtype, indx):
  if type(indx) is int:
    if indx < 0:
      indx += len(seqtype)
    if indx < 0 or indx >= len(seqtype):
      raise IndexError
    else:
      return indx
  elif type(indx) is slice:
    rng = range_from_slice(indx, len(seqtype))
    slc = []
    for indx in rng:
      slc.append(seqtype[indx])
    return slc
  else:
    raise TypeError

def range_from_slice(slc, listlen):
  step = slc.step
  if step == None:
    step = 1
  if step > 0:
    start = getslcindx(slc.start, listlen, 0)
    stop = getslcindx(slc.stop, listlen, listlen)
  else:
    start = getslcindx(slc.start, listlen, listlen - 1)
    stop = getslcindx(slc.stop, listlen, -1)
  if start >= listlen:
    start = listlen - 1
  return range(start, stop, step)

def getslcindx(indx, listlen, default):
  if indx == None:
    return default
  if indx < 0:
    indx += listlen
  if indx < 0:
    indx = 0
  if indx > listlen:
    indx = listlen
  return indx

class modlist(object):
  def __init__(self, modpt, dim, getfunc, setfunc):
    self.__modpt = modpt
    self.__dim = dim
    self.__getfunc = getfunc
    self.__setfunc = setfunc

  def __len__(self):
    return self.__dim

  def __str__(self):
    return str([val for val in self])

  def __repr__(self):
    return str([val for val in self])

  def __getitem__(self, indx):
    ret = handle_seq_indx(self, indx)
    if type(ret) is int:
      return self.__getfunc(self.__modpt, ret)
    else:
      return ret

  def __setitem__(self, indx, val):
    return self.__setfunc(self.__modpt, indx, val)
