#   residue   spline values
chi4 = [
    ( 'LYS', (0.0236, 0.1757, 0.3690, 0.6075, 0.9362, 1.2464, 1.5232, 1.7727, 1.9952, 2.2119, 2.4082, 2.5826, 2.7379, 2.8723, 3.0065, 3.1285, 3.2481, 3.3599, 3.4566, 3.5390, 3.5904, 3.6293, 3.6684, 3.7165, 3.7761, 3.8290, 3.8524, 3.8290, 3.7818, 3.7205, 3.6452, 3.5904, 3.5257, 3.4490, 3.3863, 3.3007, 3.2197, 3.1087, 2.9602, 2.7908, 2.5817, 2.3728, 2.1497, 1.9304, 1.7309, 1.5724, 1.4810, 1.4677, 1.5497, 1.7193, 1.9770, 2.3015, 2.6545, 3.0144, 3.3135, 3.5741, 3.7889, 3.9627, 4.1360, 4.2759, 4.3918, 4.4979, 4.5812, 4.6364, 4.6773, 4.7127, 4.7588, 4.8171, 4.8875, 4.9292, 4.9587, 4.9773, 4.9843, 4.9773, 4.9247, 4.8769, 4.8211, 4.7664, 4.7273, 4.6618, 4.5765, 4.4878, 4.3984, 4.3019, 4.2128, 4.1012, 3.9559, 3.7740, 3.5356, 3.2590, 2.9334, 2.5994, 2.2672, 1.9676, 1.7409, 1.5856, 1.5226, 1.5490, 1.6450, 1.8051, 1.9923, 2.1851, 2.3795, 2.5669, 2.7589, 2.9493, 3.1186, 3.2556, 3.3650, 3.4449, 3.5185, 3.5933, 3.6621, 3.7326, 3.7868, 3.8062, 3.7968, 3.7918, 3.8033, 3.8231, 3.8509, 3.8335, 3.7441, 3.6515, 3.5524, 3.4597, 3.3697, 3.2531, 3.1226, 2.9775, 2.8284, 2.6796, 2.5209, 2.3539, 2.1772, 1.9794, 1.7555, 1.4940, 1.1981, 0.8744, 0.5525, 0.3210, 0.1377, 0.0000) ),
    ( 'ARG', (0.0000, 0.0564, 0.1271, 0.2180, 0.3459, 0.4823, 0.6240, 0.7738, 0.9149, 1.0471, 1.1757, 1.2875, 1.3927, 1.4966, 1.5805, 1.6570, 1.7212, 1.7663, 1.8128, 1.8446, 1.8638, 1.8698, 1.8577, 1.8317, 1.7907, 1.7312, 1.6467, 1.5512, 1.4552, 1.3666, 1.2910, 1.2126, 1.1070, 0.9609, 0.7904, 0.6163, 0.4682, 0.3638, 0.3033, 0.2930, 0.3335, 0.4240, 0.5684, 0.7611, 0.9914, 1.2525, 1.5331, 1.8289, 2.1466, 2.4794, 2.8140, 3.1373, 3.4211, 3.6457, 3.8294, 3.9569, 4.0546, 4.1227, 4.1629, 4.2140, 4.2745, 4.3388, 4.4001, 4.4614, 4.4976, 4.5310, 4.5611, 4.5698, 4.5921, 4.6242, 4.6621, 4.6767, 4.6669, 4.6477, 4.6057, 4.5876, 4.5787, 4.5611, 4.5611, 4.5524, 4.5310, 4.5017, 4.4575, 4.4341, 4.4151, 4.3744, 4.3215, 4.2110, 4.0625, 3.8811, 3.6439, 3.3654, 3.0791, 2.7715, 2.4494, 2.1381, 1.8181, 1.5188, 1.2505, 1.0170, 0.8250, 0.6769, 0.5775, 0.5231, 0.5192, 0.5600, 0.6356, 0.7415, 0.8604, 0.9796, 1.0860, 1.1663, 1.2293, 1.2758, 1.3281, 1.3867, 1.4440, 1.5091, 1.5573, 1.6091, 1.6508, 1.6775, 1.7100, 1.7238, 1.7312, 1.7379, 1.7235, 1.6871, 1.6282, 1.5376, 1.4324, 1.3290, 1.2295, 1.1250, 1.0032, 0.8674, 0.7202, 0.5727, 0.4377, 0.3117, 0.1985, 0.1186, 0.0577, 0.0136) ),
  ]

def make_restraints(atmsel, restraints, num_selected):
    from modeller import forms, physical, features
    for (res, values) in chi4:
        arr = True
        for a in atmsel.find_chi4_dihedrals(res, num_selected):
            r = forms.spline(physical.chi4_dihedral,
                             features.dihedral(*a), open=False, low=-3.11978,
                             high=3.16341, delta=0.04363, lowderiv=0,
                             highderiv=0, values=values, use_array=arr)
            arr = restraints.add(r)
