import _modeller
from builtin_optimizer import builtin_optimizer

class conjugate_gradients(builtin_optimizer):
    """Optimize with Beale restraint conjugate gradients method"""
    __modpt = None
    __ok_keys = ( 'edat', 'libs', 'schedule_scale', 'residue_span_range',
                  'max_iterations', 'min_atom_shift', 'output', 'actions' )

    def __new__(cls, *args, **vars):
        obj = builtin_optimizer.__new__(cls)
        obj.__modpt = _modeller.new_cg_optimizer(obj)
        return obj

    def __init__(self, **vars):
        builtin_optimizer.__init__(self)
        self.__params = {}
        self._update_params(self.__params, self.__ok_keys, vars)

    def __del__(self):
        _modeller.free_cg_optimizer(self.modpt)

    def __get_modpt(self):
        return self.__modpt
    def __get_optpt(self):
        return _modeller.cg_optimizer_opt_get(self.__modpt)

    def optimize(self, atmsel, **vars):
        """Optimize the given atom selection"""
        (top, mdl, libs, edat, inds, vars) = \
            self._prep_builtin_optimizer(atmsel, self.__params, self.__ok_keys,
                                         vars)
        self._prep_actions(vars)
        self.atmsel = atmsel
        ret = top.cg_optimize('cg_optimize', cgopt=self.modpt, mdl=mdl.modpt,
                              edat=edat.modpt, libs=libs.modpt, sel1=inds,
                              **vars)
        self.atmsel = None
        return ret

    def trace(self, out):
        """Write out information about the current optimization step"""
        if self.step == 0:
            out.write("# Conjugate gradients optimization\n")
            out.write("# %5s %16s %8s %8s %7s %16s\n" \
                       % ('Step', 'Current energy', 'Av shift',
                         'Mx shift', 'Funcs', 'Gradient'))
        log = "%7d %16.5f %8.4f %8.4f %7d %16.6g\n" \
               % (self.step, self.current_e, self.shiftavr,
                  self.shiftmax, self.funcs, self.gsq)
        out.write(log)

    def __get_gsq(self):
        return _modeller.cg_optimizer_gsq_get(self.modpt)

    modpt = property(__get_modpt)
    optpt = property(__get_optpt)
    gsq = property(__get_gsq, doc="Current gradient")
