import _modeller
from builtin_optimizer import builtin_optimizer

class state_optimizer(builtin_optimizer):
    __modpt = None
    _ok_keys = ( 'actions', 'schedule_scale', 'libs', 'edat')

    def __new__(cls, *args, **vars):
        obj = builtin_optimizer.__new__(cls)
        obj.__modpt = _modeller.new_state_optimizer(obj)
        return obj

    def __init__(self, **vars):
        builtin_optimizer.__init__(self)
        self._params = {}
        self._update_params(self._params, self._ok_keys, vars)

    def __del__(self):
        _modeller.free_state_optimizer(self.modpt)

    def __get_modpt(self):
        return self.__modpt
    def __get_optpt(self):
        return _modeller.state_optimizer_opt_get(self.__modpt)

    def optimize(self, atmsel, **vars):
        """Optimize the given atom selection."""
        self.atmsel = atmsel
        (top, mdl, libs, edat, inds, vars) = \
            self._prep_builtin_optimizer(atmsel, self._params, self._ok_keys,
                                         vars)
        self.actions = self._params.get("actions", [])
        if not isinstance(self.actions, (list, tuple)):
            self.actions = (self.actions,)
        self.__edat = edat
        self.__libs = libs
        _modeller.state_optimizer_start(self.modpt, mdl.modpt, libs.modpt,
                                        edat.modpt, inds)
        self.next_step()

    def next_step(self):
        """Proceed to the next optimization step."""
        self._do_actions(False)
        _modeller.state_optimizer_next_step(self.modpt)

    def finish(self):
        """Do any cleanup at the end of optimization."""
        self._do_actions(True)

    def _do_actions(self, last):
        """Carry out all periodic actions"""
        step = self.step
        for a in self.actions:
            if (step == 0 and a.first) or \
               (step != 0 and not last and step % a.skip == 0) or \
               (step != 0 and last and a.last and step % a.skip != 0):
                a(self)

    def get_state(self):
        """Converts the selection coordinates into a state vector, and returns
           it."""
        return list(_modeller.get_state_optimizer_state(self.modpt))

    def set_state(self, state):
        """Converts the given state vector back into selection coordinates.
           Also calculates the atom shifts from the old state."""
        _modeller.set_state_optimizer_state(self.modpt, self.__edat.modpt,
                                            state)

    def energy(self, state):
        """Given a state vector, returns the energy and first derivatives."""
        return _modeller.state_optimizer_energy(self.modpt, self.__edat.modpt,
                                                state, self.__libs.modpt)

    def energy_only(self, state):
        """Given a state vector, returns just the energy."""
        return _modeller.state_optimizer_energy_only(self.modpt,
                                                     self.__edat.modpt, state,
                                                     self.__libs.modpt)

    def get_parameter(self, key, default):
        """Get an optimization keyword parameter"""
        return self._params.get(key, default)

    def trace(self, out):
        """Write out information about the current optimization step"""
        if self.step == 0:
            out.write("# %5s %16s %8s %8s %7s\n" \
                       % ('Step', 'Current energy', 'Av shift',
                         'Mx shift', 'Funcs'))
        log = "%7d %16.5f %8.4f %8.4f %7d\n" \
               % (self.step, self.current_e, self.shiftavr,
                  self.shiftmax, self.funcs)
        out.write(log)

    modpt = property(__get_modpt)
    optpt = property(__get_optpt)
