e_all__ = ["mypopen4"]

import os

try:
    from popen2 import Popen4

    class mypopen4(Popen4):
        def require_clean_exit(self):
            r = self.wait()
            if os.WIFSIGNALED(r):
                raise IOError, "Process failed with signal %d" % os.WTERMSIG(r)
            elif os.WIFEXITED(r) and os.WEXITSTATUS(r) != 0:
                raise IOError, \
                      "Process failed with exit status %d" % os.WEXITSTATUS(r)

except ImportError:

    class mypopen4:
        """Emulation for popen2.Popen4 class on non-Unix systems"""
        def __init__(self, cmd):
            self.tochild, self.fromchild = os.popen4(cmd)
        def require_clean_exit(self):
            pass
