from modeller import *

e=environ()
e.io.atom_files_directory = '../atom_files'
# read in different topology
log.verbose()
code = '1nbt.pdb'
a = model(e, file=code)
s = saxsdata(e)
s.ini_saxs(mesh_density=.01, maxs=500, nmesh=100, natomtyp=5, represtyp='allatm', filename='xxx.txt')
a.saxs_intens(saxsd=s, filename='i_s.txt')
# read in different topology
e.libs.topology.read(file='$(LIB)/top_ca.lib')
e.libs.parameters.read(file='$(LIB)/par.lib')
aln = alignment(e)
aln.append_model(a, atom_files=code, align_codes=code)
aln.append_model(a, atom_files=code+'.ini', align_codes=code+'-ini')
a.generate_topology(aln[code+'-ini'])
a.transfer_xyz(aln)
a.build(initialize_xyz=False, build_method='INTERNAL_COORDINATES')
s.ini_saxs(mesh_density=.01, maxs=500, nmesh=500, natomtyp=20, represtyp='CA', filename='$(LIB)/CA3gaussfit.dat')
a.saxs_intens(saxsd=s, filename='i_s_CA.txt')

