import _modeller
import modeller.util.top as top

class information(object):
    """Allows access to information about the current Modeller build"""

    def __init__(self):
        self.top = top.top()

    def time_mark(self):
        """Returns the current date, time, and CPU time used"""
        return self.top.time_mark('info.time_mark')

    def __get_version(self):
        return _modeller.get_mod_long_version()
    def __get_version_info(self):
        mod_version = _modeller.get_mod_short_version()
        try:
            return (int(mod_version[0]), int(mod_version[2]))
        except ValueError:
            return mod_version
    def __get_build_date(self):
        return _modeller.get_build_date()
    def __get_exe_type(self):
        return _modeller.get_exe_type()
    def __get_debug(self):
        return _modeller.get_debug()

    version = property(__get_version, doc="The Modeller version, as a string")
    version_info = property(__get_version_info,
                            doc="The Modeller major, minor version numbers")
    build_date = property(__get_build_date,
                          doc="The date this Modeller binary was built")
    exe_type = property(__get_exe_type,
                        doc="The executable type of this Modeller binary")
    debug = property(__get_debug, doc="Whether this is a debugging build")


# Global information object
info = information()
