import os
import job, sge_qsub_slave

class sge_qsub_job(job.job):
    """A parallel job which automatically starts Sun Grid Engine processes
       using 'qsub'."""

    def __init__(self, options, maxslave, seq=(), modeller_path=None,
                 host=None):
        job.job.__init__(self, seq, modeller_path, host)
        self.options = options
        self.maxslave = maxslave

    def expand_for_tasks(self):
        numslaves = len(self)
        numdesired = len(self.tasks)
        if self.maxslave is not None and self.maxslave < numdesired:
            numdesired = self.maxslave
        while numslaves < numdesired:
            numslaves += 1
            self.append(sge_qsub_slave.sge_qsub_slave(self.options))
