import _modeller
import util.top as top
import util.modutil as modutil
from modeller.util.modobject import modobject
import alignment
import pssmdb

class profile(modobject):
    """Holds a profile of multiple sequences"""
    __modpt = None
    env = None
    top = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_profile(obj)
        return obj

    def __init__(self, env, aln=None, **vars):
        self.env = env.copy()
        self.top = top.top(self.env)
        if aln is not None:
            self.top.aln_to_prof('alignment.to_profile', aln=aln.modpt,
                                 prf=self.modpt, **vars)
        elif len(vars) > 0:
            self.read(**vars)

    def __del__(self):
        _modeller.free_profile(self.modpt)

    def __get_modpt(self):
        return self.__modpt

    def __len__(self):
        return _modeller.profile_nseq_get(self.modpt)

    def read(self, **vars):
        """Reads a profile from a specified file"""
        return self.top.read_profile('profile.read', prf=self.modpt,
                                     libs=self.env.libs.modpt, **vars)

    def write(self, **vars):
        """Write profile to a file"""
        return self.top.write_profile('profile.write', prf=self.modpt,
                                      libs=self.env.libs.modpt, **vars)

    def build(self, sdb, **vars):
        """Refines the profile with sequences from the given database"""
        return self.top.build_profile('profile.build', prf=self.modpt,
                                      sdb=sdb.modpt, libs=self.env.libs.modpt,
                                      **vars)

    def to_alignment(self):
        """Converts the profile to alignment format"""
        aln = alignment.alignment(self.env)
        self.top.prof_to_aln('profile.to_alignment', prf=self.modpt,
                             aln=aln.modpt, libs=self.env.libs.modpt)
        return aln

    def scan(self, psm=None, **vars):
        """Compare the profile against a database of profiles"""
        if psm is None:
            psm = pssmdb.pssmdb(self.env)
        return self.top.profile_profile_scan('profile.scan', prf=self.modpt,
                                             pssmdb=psm.modpt, 
                                             libs=self.env.libs.modpt, **vars)

    def __getitem__(self, indx):
        ret = modutil.handle_seq_indx(self, indx)
        if type(ret) is int:
            return sequence(self, indx)
        else:
            return [self[ind] for ind in ret]

    modpt = property(__get_modpt)


class sequence(object):

    def __init__(self, prf, num):
        self.prf = prf
        self.num = num

    def __len__(self):
        nres = _modeller.profile_nres_get(self.prf.modpt)
        return _modeller.f_int1_get(nres, self.num)

    def __get_code(self):
        return _modeller.get_profile_code(self.prf.modpt, self.num)
    def __set_code(self, val):
        _modeller.set_profile_code(self.prf.modpt, self.num, val)
    def __get_prottyp(self):
        return _modeller.get_profile_prottyp(self.prf.modpt, self.num)
    def __set_prottyp(self, val):
        _modeller.set_profile_prottyp(self.prf.modpt, self.num, val)
    def __get_iter(self):
        iter = _modeller.profile_iter_get(self.prf.modpt)
        return _modeller.f_int1_get(iter, self.num)
    def __get_neqv(self):
        neqv = _modeller.profile_neqv_get(self.prf.modpt)
        return _modeller.f_int1_get(neqv, self.num)
    def __get_fid(self):
        fid = _modeller.profile_fid_get(self.prf.modpt)
        return _modeller.f_float1_get(fid, self.num)
    def __get_evalue(self):
        evalue = _modeller.profile_evalue_get(self.prf.modpt)
        return _modeller.f_double1_get(evalue, self.num)

    code = property(__get_code, __set_code)
    prottyp = property(__get_prottyp, __set_prottyp)
    iter = property(__get_iter)
    neqv = property(__get_neqv)
    fid = property(__get_fid)
    evalue = property(__get_evalue)
