from modeller import model, alignment

def complete_pdb(env, filename, special_patches=None, transfer_res_num=False,
                 model_segment=None):
    """Reads the given PDB file, reorders the atoms to match the current
       topology library, and adds any missing atoms.

       If 'special_patches' is set, it is expected to be a routine which
       takes one parameter (the model) and applies any patches (e.g.
       disulfide bridges).

       If 'transfer_res_num' is True, the residue numbering from the
       original PDB is retained (by default, residues are renumbered from 1).

       You should read topology and parameters into 'env' before calling
       this routine. The completed model is returned."""
       
    vars = {}
    if model_segment is not None:
        vars['model_segment'] = model_segment
    mdl = model(env, file=filename, **vars)
    aln = alignment(env)
    aln.append_model(mdl, atom_files=filename, align_codes='struc')
    aln.append_model(mdl, atom_files=filename+'.ini', align_codes='struc-ini')
    mdl.clear_topology()
    mdl.generate_topology(aln[-1])
    if special_patches:
        special_patches(mdl)
    # Save original seq_id, as transfer_xyz sets it
    seq_id = mdl.seq_id
    mdl.transfer_xyz(aln)
    mdl.seq_id = seq_id
    mdl.build(initialize_xyz=False, build_method='INTERNAL_COORDINATES')
    if transfer_res_num:
        mdl2 = model(env, file=filename, **vars)
        mdl.res_num_from(mdl2, aln)
    return mdl
