import _modeller
import residue
from modeller.util.modobject import modobject
from modeller.util import modlist

class seqrange(modlist.fixlist):
    def __init__(self, seq):
        self.__seq = seq
        modlist.fixlist.__init__(self)

    def __len__(self):
        return 2

    def _getfunc(self, indx):
        return _modeller.sequence_rng_get(self.__seq.seqpt, indx)

    def _setfunc(self, indx, val):
        _modeller.sequence_rng_set(self.__seq.seqpt, indx, val)


class sequence(modobject):
    def __get_nseg(self):
        return _modeller.sequence_nseg_get(self.seqpt)
    def __get_nres(self):
        return _modeller.sequence_nres_get(self.seqpt)
    def __get_range(self):
        return seqrange(self)
    def __set_range(self, val):
        modlist.set_fixlist(self.range, val)
    def __get_source(self):
        return _modeller.sequence_source_get(self.seqpt)
    def __set_source(self, val):
        _modeller.sequence_source_set(self.seqpt, val)
    def __get_name(self):
        return _modeller.sequence_name_get(self.seqpt)
    def __set_name(self, val):
        _modeller.sequence_name_set(self.seqpt, val)
    def __get_prottyp(self):
        return _modeller.sequence_prottyp_get(self.seqpt)
    def __set_prottyp(self, val):
        return _modeller.sequence_prottyp_set(self.seqpt, val)
    def __get_resol(self):
        return _modeller.sequence_resol_get(self.seqpt)
    def __set_resol(self, val):
        return _modeller.sequence_resol_set(self.seqpt, val)
    def __get_rfactr(self):
        return _modeller.sequence_rfactr_get(self.seqpt)
    def __set_rfactr(self, val):
        return _modeller.sequence_rfactr_set(self.seqpt, val)

    nseg = property(__get_nseg)
    nres = property(__get_nres, doc="Number of residues")
    range = property(__get_range, __set_range,
                     doc="Residue number and chain ID range")
    source = property(__get_source, __set_source, doc="Source organism")
    name = property(__get_name, __set_name, doc="Protein name")
    prottyp = property(__get_prottyp, __set_prottyp,
                       doc="Protein sequence type")
    resolution = property(__get_resol, __set_resol, doc="Resolution")
    rfactor = property(__get_rfactr, __set_rfactr, doc="R factor")


class sequence_residue(residue.residue):
    def __get_type(self):
        irestyp = _modeller.sequence_irestyp_get(self.mdl.seqpt)
        return _modeller.f_int1_get(irestyp, self._num)
    def __set_type(self, val):
        irestyp = _modeller.sequence_irestyp_get(self.mdl.seqpt)
        _modeller.f_int1_set(irestyp, self._num, val)
    def __get_chain(self):
        ichain = _modeller.sequence_chain_for_residue(self.mdl.seqpt, self._num)
        return self.mdl.chains[ichain]
    type = property(__get_type, __set_type, doc="Integer residue type")
    chain = property(__get_chain, doc="Chain containing this residue")
