from modeller.util.modlist import linklist
import _modeller

class energy_term(object):
    _physical_type = None

    def _add_term(self, edat, indx):
        _modeller.new_energy_term(edat, indx, self.eval,
                                  self._physical_type.get_num())

    def eval(self, mdl, deriv, indats):
        raise NotImplementedError, "No Python function for energy term"

    def indices_to_atoms(self, mdl, atom_indices):
        """Converts Modeller-style atom indices into atom objects"""
        return [mdl.atoms[x-1] for x in atom_indices]

class termlist(linklist):
    def __init__(self, edat):
        self.__edat = edat
        self.__list = []
        linklist.__init__(self)

    def _insfunc(self, indx, obj):
        obj._add_term(self.__edat, indx)
        self.__list.insert(indx, obj)
    def __len__(self):
        return len(self.__list)
    def _getfunc(self, indx):
        return self.__list[indx]
    def _delfunc(self, indx):
        del self.__list[indx]
        _modeller.del_energy_term(self.__edat, indx)
