/** Prototype for callback functions accepted by set_log_function() */
typedef int (*cb_log)(void *logdata, const char *text);

/** Write text directly to the log (no additional newline is appended) */
void wrtlog(const char *str);

/** Get the current log level */
int modget_log(int level);

/** Set the current log level */
void modset_log(int level, int value);

/** Install a callback function to handle all log output */
void modset_log_function(cb_log logfunc, cb_free freefunc, void *logdata);
