%module _modeller

%{
#include "modeller.h"
#include "mod_dynmem.h"
%}

%include "custom-typemaps.i"

typedef int mbool;

/* Wrap some Modeller functions and structures directly from the header files */
%include "../include/modeller.h"
%include "../include/mod_core.h"
%include "../include/mod_selection.h"
%include "../include/mod_libs.h"
%include "../include/mod_file.h"
%include "../include/mod_build.h"
%include "../include/mod_info.h"
%include "../include/mod_system.h"
%include "../include/mod_ga341.h"
%include "../include/user_features.h"
%include "../include/user_forms.h"
%include "../include/user_terms.h"
%include "../include/user_simloc.h"
%include "../include/optimizer_actions.h"

/* Provide custom wrapping of some Modeller structures and functions */
%include "mod_log.i"
%include "optimizer.i"
%include "coordinates.i"
%include "model.i"
%include "alignment.i"
%include "profile.i"
%include "topology.i"
%include "density.i"
%include "sequence.i"
%include "sequence_db.i"
%include "saxsdata.i"
%include "pseudo_atoms.i"
%include "symmetry.i"
%include "restraints.i"
%include "fortran-pointers.i"
%include "model_topology.i"
%include "structure.i"
%include "libraries.i"
%include "parameters.i"
%include "schedule.i"

%init {
#ifdef SWIGPYTHON
  moderror = PyErr_NewException("_modeller.error", NULL, NULL);
  Py_INCREF(moderror);
  PyModule_AddObject(m, "error", moderror);
#endif
}
