import _modeller
import util.top as top
from modeller.util.modobject import modobject

class group_restraints(modobject):
    """Holds restraints which act on atom classes/groups"""
    __modpt = None
    env = None
    __class_file = None
    __param_files = None

    def __new__(cls, *args, **vars):
        obj = modobject.__new__(cls)
        obj.__modpt = _modeller.new_group_restraints(obj)
        return obj

    def __init__(self, env, classes, parameters=None):
        self.env = env.copy()
        self.__read_classes(classes)
        self.__param_files = []
        if parameters:
            self.append(parameters)

    def __del__(self):
        _modeller.free_group_restraints(self.modpt)

    def __setstate__(self, d):
        """Restore internal information from files"""
        self.__dict__.update(d)
        self.__read_classes(self.__class_file)
        params = self.__param_files
        self.__param_files = []
        for file in params:
            self.append(file)

    def __get_modpt(self):
        return self.__modpt

    def __read_classes(self, file):
        """Read atom classes from a file"""
        self.__class_file = file
        return top.top().read_atom_classes('group_restraints()',
                                           gprsr=self.modpt,
                                           atom_classes_file=file)

    def append(self, file):
        """Read interaction parameters from a file"""
        self.__param_files.append(file)
        return top.top().read_group_restraints('group_restraints.append',
                                               gprsr=self.modpt, file=file,
                                               libs=self.env.libs.modpt)

    modpt = property(__get_modpt)
