import _modeller
import util.top as top

class topology(object):
    """All information from a residue topology file"""

    def __init__(self, libs):
        self.env = libs.env
        self.__modpt = _modeller.libraries_tpl_get(libs.modpt)
        self.top = top.top(self.env)

    def __get_modpt(self):
        return self.__modpt

    def clear(self):
        _modeller.clear_topology(self.modpt, self.env.libs.modpt)

    def read(self, file):
        """Reads a residue topology file"""
        self.clear()
        return self.append(file)

    def append(self, file):
        """Appends a residue topology file"""
        return self.top.read_topology('topology.append', tpl=self.modpt, 
                                      file=file, libs=self.env.libs.modpt)

    def make(self, submodel):
        """Reduces the most detailed topology to a sub-topology model"""
        self.submodel = submodel
        return self.top.make_topology_model('topology.make', tpl=self.modpt)

    def write(self, file):
        """Writes topology library to a file"""
        return self.top.write_topology_model('topology.write', tpl=self.modpt,
                                             file=file,
                                             libs=self.env.libs.modpt)

    def __get_submodel(self):
        return _modeller.topology_submodel_get(self.modpt)
    def __set_submodel(self, val):
        _modeller.topology_submodel_set(self.modpt, val)
    def __get_in_memory(self):
        return _modeller.topology_read(self.modpt)

    modpt = property(__get_modpt)
    submodel = property(__get_submodel, __set_submodel)
    in_memory = property(__get_in_memory)
